/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class SqlStatementBuilder {
    private final StringBuilder builder = new StringBuilder();

    public SqlStatementBuilder append(Object value) {
        this.builder.append(value);
        return this;
    }

    public SqlStatementBuilder appendList(Collection<String> columnNames, Function<String, String> transform) {
        this.appendList(",", columnNames, transform);
        return this;
    }

    public SqlStatementBuilder appendList(String delimiter, Collection<String> columnNames, Function<String, String> transform) {
        Iterator<String> iterator = columnNames.iterator();
        while (iterator.hasNext()) {
            this.builder.append(transform.apply(iterator.next()));
            if (!iterator.hasNext()) continue;
            this.builder.append(delimiter);
        }
        return this;
    }

    public SqlStatementBuilder appendLists(Collection<String> columnNames1, Collection<String> columnNames2, Function<String, String> transform) {
        this.appendLists(",", columnNames1, columnNames2, transform);
        return this;
    }

    public SqlStatementBuilder appendLists(String delimiter, Collection<String> columnNames1, Collection<String> columnNames2, Function<String, String> transform) {
        this.appendList(delimiter, columnNames1, transform);
        if (!columnNames1.isEmpty() && !columnNames2.isEmpty()) {
            this.builder.append(delimiter);
        }
        this.appendList(delimiter, columnNames2, transform);
        return this;
    }

    public String build() {
        return this.builder.toString();
    }
}

