/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.testcontainers.containers.JdbcDatabaseContainer;

public abstract class JdbcConnectionProvider
implements AutoCloseable {
    private final JdbcDatabaseContainer<?> container;
    private final ConnectionInitializer initializer;
    private Connection connection;

    public JdbcConnectionProvider(JdbcDatabaseContainer<?> container, ConnectionInitializer initializer) {
        this.container = container;
        this.initializer = initializer;
    }

    public String getUsername() {
        return this.container.getUsername();
    }

    public String getPassword() {
        return this.container.getPassword();
    }

    public String getContainerName() {
        return this.container.getContainerName().substring(1);
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.connection = null;
    }

    public void execute(String statement) throws SQLException {
        Connection connection = this.getConnection();
        try (Statement st = connection.createStatement();){
            st.execute(statement);
        }
        catch (SQLException e) {
            throw new SQLException("Failed to execute SQL: " + statement, e);
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    public void execute(String statement, String sta) throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        try (Statement st = connection.createStatement();){
            st.execute(statement);
            st.execute(sta);
        }
        catch (SQLException e) {
            throw new SQLException("Failed to execute SQL: " + statement, e);
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    protected void queryContainer(String header, List<String> commands) throws Exception {
        System.out.println(header);
        System.out.println("------------------------------------------------------------------------------------------");
        if (commands.size() > 4) {
            Process proc = Runtime.getRuntime().exec(commands.toArray(new String[0]));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                System.out.println(s);
            }
            while ((s = stdError.readLine()) != null) {
                System.out.println(s);
            }
            proc.waitFor();
            System.out.println("");
        }
    }

    protected JdbcDatabaseContainer<?> getContainer() {
        return this.container;
    }

    protected Connection getConnection() throws SQLException {
        if (!this.isInitialized()) {
            this.connection = this.container.createConnection("");
            if (this.initializer != null) {
                this.initializer.initialize(this.connection);
            }
        }
        return this.connection;
    }

    protected boolean isInitialized() throws SQLException {
        return this.connection != null && !this.connection.isClosed();
    }

    @FunctionalInterface
    public static interface ConnectionInitializer {
        public void initialize(Connection var1) throws SQLException;
    }
}

