/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkInsertModeTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.PostgresSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.junit.jupiter.WithPostgresExtension;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.DataSourceWithLetterCase;
import org.assertj.db.type.ValueType;
import org.assertj.db.type.lettercase.CaseComparison;
import org.assertj.db.type.lettercase.CaseComparisons;
import org.assertj.db.type.lettercase.CaseConversion;
import org.assertj.db.type.lettercase.CaseConversions;
import org.assertj.db.type.lettercase.LetterCase;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-postgresql")})
@ExtendWith(value={PostgresSinkDatabaseContextProvider.class})
public class JdbcSinkInsertModeIT
extends AbstractJdbcSinkInsertModeTest {
    public static final LetterCase LOWER_CASE_STRICT = LetterCase.getLetterCase((CaseConversion)CaseConversions.LOWER, (CaseComparison)CaseComparisons.STRICT);
    public static final LetterCase UPPER_CASE_STRICT = LetterCase.getLetterCase((CaseConversion)CaseConversions.UPPER, (CaseComparison)CaseComparisons.STRICT);

    public JdbcSinkInsertModeIT(Sink sink) {
        super(sink);
    }

    @WithPostgresExtension(value="postgis")
    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6637"})
    public void testInsertModeInsertWithPrimaryKeyModeComplexRecordValue(SinkRecordFactory factory) throws SQLException {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        properties.put("dialect.postgres.postgis.schema", "postgis");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        Schema geometrySchema = JdbcSinkInsertModeIT.buildGeoTypeSchema("Geometry");
        Struct geometryValue = new Struct(geometrySchema).put("wkb", (Object)Base64.getDecoder().decode("AQMAAAABAAAABQAAAAAAAAAAAAAAAAAAAAAAFEAAAAAAAAAAQAAAAAAAABRAAAAAAAAAAEAAAAAAAAAcQAAAAAAAAAAAAAAAAAAAHEAAAAAAAAAAAAAAAAAAABRA".getBytes()));
        Schema pointSchema = JdbcSinkInsertModeIT.buildGeoTypeSchema("Point");
        Struct pointValue = new Struct(pointSchema).put("x", (Object)1.0).put("y", (Object)1.0).put("wkb", (Object)Base64.getDecoder().decode("AQEAAAAAAAAAAADwPwAAAAAAAPA/".getBytes())).put("srid", (Object)3187);
        Schema geographySchema = JdbcSinkInsertModeIT.buildGeoTypeSchema("Geography");
        Struct geographyValue = new Struct(geographySchema).put("wkb", (Object)Base64.getDecoder().decode("AQUAACDmEAAAAQAAAAECAAAAAgAAAKd5xyk6JGVAC0YldQJaRsDGbTSAt/xkQMPTK2UZUkbA".getBytes())).put("srid", (Object)4326);
        SinkRecord createGeometryRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, List.of("geometry", "point", "geography", "p"), List.of(geometrySchema, pointSchema, geographySchema, pointSchema), Arrays.asList(geometryValue, pointValue, geographyValue));
        this.consume(createGeometryRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createGeometryRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        PGobject expectedValue = new PGobject();
        expectedValue.setType("\"postgis\".\"geometry\"");
        expectedValue.setValue("01030000000100000005000000000000000000000000000000000014400000000000000040000000000000144000000000000000400000000000001C4000000000000000000000000000001C4000000000000000000000000000001440");
        this.getSink().assertColumnType(tableAssert, "geometry", PGobject.class, expectedValue);
        PGpoint expectedPoint = new PGpoint(1.0, 1.0);
        this.getSink().assertColumnType(tableAssert, "point", PGobject.class, expectedPoint);
        PGobject expectedGeographyValue = new PGobject();
        expectedGeographyValue.setType("\"postgis\".\"geography\"");
        expectedGeographyValue.setValue("0105000020E610000001000000010200000002000000A779C7293A2465400B462575025A46C0C66D3480B7FC6440C3D32B65195246C0");
        this.getSink().assertColumnType(tableAssert, "geography", PGobject.class, expectedGeographyValue);
        this.getSink().assertColumnHasNullValue(tableAssert, "p");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6682"})
    public void testInsertModeInsertWithPrimaryKeyModeUpperCaseColumnNameWithQuotedIdentifiers(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "ID");
        properties.put("quote.identifiers", "true");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createSimpleRecord1 = factory.createRecord(topicName, (byte)1, String::toUpperCase);
        SinkRecord createSimpleRecord2 = factory.createRecord(topicName, (byte)2, String::toUpperCase);
        this.consume(createSimpleRecord1);
        this.consume(createSimpleRecord2);
        DataSourceWithLetterCase dataSourceWithLetterCase = new DataSourceWithLetterCase(this.dataSource(), LetterCase.TABLE_DEFAULT, UPPER_CASE_STRICT, UPPER_CASE_STRICT);
        TableAssert tableAssert = TestHelper.assertTable((DataSource)dataSourceWithLetterCase, this.destinationTableName(createSimpleRecord1));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(2)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "ID", ValueType.NUMBER, (byte)1, (byte)2);
        this.getSink().assertColumnType(tableAssert, "NAME", ValueType.TEXT, "John Doe", "John Doe");
        this.getSink().assertColumnType(tableAssert, "NICK_NAME$", ValueType.TEXT, "John Doe$", "John Doe$");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6682"})
    public void testInsertModeInsertWithPrimaryKeyModeUpperCaseColumnNameWithoutQuotedIdentifiers(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "ID");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createSimpleRecord1 = factory.createRecord(topicName, (byte)1, String::toUpperCase);
        SinkRecord createSimpleRecord2 = factory.createRecord(topicName, (byte)2, String::toUpperCase);
        this.consume(createSimpleRecord1);
        this.consume(createSimpleRecord2);
        DataSourceWithLetterCase dataSourceWithLetterCase = new DataSourceWithLetterCase(this.dataSource(), LetterCase.TABLE_DEFAULT, LOWER_CASE_STRICT, LOWER_CASE_STRICT);
        TableAssert tableAssert = TestHelper.assertTable((DataSource)dataSourceWithLetterCase, this.destinationTableName(createSimpleRecord1), null, null);
        ((TableAssert)tableAssert.exists().hasNumberOfRows(2)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1, (byte)2);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe", "John Doe");
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$", "John Doe$");
    }

    private static Schema buildGeoTypeSchema(String type) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("io.debezium.data.geometry." + type).field("wkb", Schema.BYTES_SCHEMA).field("srid", Schema.OPTIONAL_INT32_SCHEMA).optional();
        if ("Point".equals(type)) {
            schemaBuilder.field("x", Schema.FLOAT64_SCHEMA).field("y", Schema.FLOAT64_SCHEMA);
        }
        return schemaBuilder.build();
    }
}

