/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.type.AbstractType;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class AbstractGeoType
extends AbstractType {
    public static final String SRID = "srid";
    public static final String WKB = "wkb";

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Struct) {
            Integer srid = Optional.ofNullable(((Struct)value).getInt32(SRID)).orElse(0);
            byte[] wkb = ((Struct)value).getBytes(WKB);
            return List.of(new ValueBindDescriptor(index, wkb), new ValueBindDescriptor(index + 1, srid));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

