/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.transforms;

import io.debezium.connector.jdbc.transforms.ConvertCloudEventToSaveableForm;
import io.debezium.connector.jdbc.util.DebeziumSinkRecordFactory;
import io.debezium.converters.spi.SerializerType;
import io.debezium.doc.FixFor;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ConvertCloudEventToSaveableFormTest {
    ConvertCloudEventToSaveableFormTest() {
    }

    @Test
    @FixFor(value={"DBZ-7065", "DBZ-7130"})
    void testConvertCloudEventRecordWithEmptyConfig() {
        try (ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();){
            HashMap config = new HashMap();
            Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(ConfigException.class, () -> transform.configure(config));
            Assertions.assertThat((String)exception.getMessage()).isEqualTo((Object)"Invalid value null for configuration serializer.type: Serialization/deserialization type of CloudEvents converter is required");
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "avro"})
    @FixFor(value={"DBZ-7065", "DBZ-7130"})
    void testConvertNotCloudEventRecord(String serializerType) {
        try (ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("serializer.type", serializerType);
            transform.configure(config);
            DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
            SinkRecord createRecord = factory.createRecord("test.topic");
            Assertions.assertThat((String)createRecord.valueSchema().name()).doesNotEndWith((CharSequence)".CloudEvents.Envelope");
            SinkRecord convertedRecord = transform.apply(createRecord);
            Assertions.assertThat((Object)convertedRecord).isEqualTo((Object)createRecord);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "avro"})
    @FixFor(value={"DBZ-7065", "DBZ-7130"})
    void testConvertCloudEventRecordWithEmptyMapping(String serializerType) {
        try (ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("serializer.type", serializerType);
            transform.configure(config);
            DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
            SinkRecord cloudEventRecord = factory.cloudEventRecord("test.topic", SerializerType.withName((String)serializerType));
            if (serializerType.equals("avro")) {
                Assertions.assertThat((String)cloudEventRecord.valueSchema().name()).endsWith((CharSequence)".CloudEvents.Envelope");
                Assertions.assertThat((int)cloudEventRecord.valueSchema().fields().size()).isEqualTo(7);
                Assertions.assertThat((Object)cloudEventRecord.valueSchema().field("id").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
            }
            SinkRecord convertedRecord = transform.apply(cloudEventRecord);
            Assertions.assertThat((Object)convertedRecord).isEqualTo((Object)cloudEventRecord);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "avro"})
    @FixFor(value={"DBZ-7065", "DBZ-7130"})
    void testConvertCloudEventRecordWithMappingOfIdField(String serializerType) {
        try (ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("fields.mapping", "id");
            config.put("serializer.type", serializerType);
            transform.configure(config);
            DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
            SinkRecord cloudEventRecord = factory.cloudEventRecord("test.topic", SerializerType.withName((String)serializerType));
            if (serializerType.equals("avro")) {
                Assertions.assertThat((String)cloudEventRecord.valueSchema().name()).endsWith((CharSequence)".CloudEvents.Envelope");
                Assertions.assertThat((int)cloudEventRecord.valueSchema().fields().size()).isEqualTo(7);
                Assertions.assertThat((Object)cloudEventRecord.valueSchema().field("id").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
            }
            SinkRecord convertedRecord = transform.apply(cloudEventRecord);
            Assertions.assertThat((Object)convertedRecord).isNotNull();
            Assertions.assertThat((Object)convertedRecord).isNotEqualTo((Object)cloudEventRecord);
            Assertions.assertThat((Comparable)convertedRecord.valueSchema().type()).isEqualTo((Object)Schema.Type.STRUCT);
            Assertions.assertThat((int)convertedRecord.valueSchema().fields().size()).isEqualTo(1);
            Assertions.assertThat((Object)convertedRecord.valueSchema().field("id").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
            Assertions.assertThat((Object)convertedRecord.value()).isInstanceOf(Struct.class);
            Assertions.assertThat((String)((Struct)convertedRecord.value()).getString("id")).isNotBlank();
            this.checkParamsOfOriginalAndConvertedRecordsAreEqual(cloudEventRecord, convertedRecord);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "avro"})
    @FixFor(value={"DBZ-7065", "DBZ-7130"})
    void testConvertCloudEventRecordWithMappingOfDataField(String serializerType) {
        try (ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("fields.mapping", "data");
            config.put("serializer.type", serializerType);
            transform.configure(config);
            DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
            SinkRecord cloudEventRecord = factory.cloudEventRecord("test.topic", SerializerType.withName((String)serializerType));
            if (serializerType.equals("avro")) {
                Assertions.assertThat((String)cloudEventRecord.valueSchema().name()).endsWith((CharSequence)".CloudEvents.Envelope");
                Assertions.assertThat((int)cloudEventRecord.valueSchema().fields().size()).isEqualTo(7);
                Assertions.assertThat((Comparable)cloudEventRecord.valueSchema().field("data").schema().type()).isEqualTo((Object)Schema.Type.STRUCT);
            }
            SinkRecord convertedRecord = transform.apply(cloudEventRecord);
            Assertions.assertThat((Object)convertedRecord).isNotNull();
            Assertions.assertThat((Object)convertedRecord).isNotEqualTo((Object)cloudEventRecord);
            Assertions.assertThat((Comparable)convertedRecord.valueSchema().type()).isEqualTo((Object)Schema.Type.STRUCT);
            Assertions.assertThat((int)convertedRecord.valueSchema().fields().size()).isEqualTo(1);
            Assertions.assertThat((Object)convertedRecord.valueSchema().field("data").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
            Assertions.assertThat((Object)convertedRecord.value()).isInstanceOf(Struct.class);
            Assertions.assertThat((String)((Struct)convertedRecord.value()).getString("data")).isNotBlank();
            this.checkParamsOfOriginalAndConvertedRecordsAreEqual(cloudEventRecord, convertedRecord);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"json", "avro"})
    @FixFor(value={"DBZ-7065", "DBZ-7130"})
    void testConvertCloudEventRecordWithMappingOfAllFieldsWithCustomNames(String serializerType) {
        try (ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();){
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("fields.mapping", "id,source:created_by,specversion:ce_spec_number,type,time:created_at,datacontenttype:payload_format,data:payload");
            config.put("serializer.type", serializerType);
            transform.configure(config);
            DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
            SinkRecord cloudEventRecord = factory.cloudEventRecord("test.topic", SerializerType.withName((String)serializerType));
            if (serializerType.equals("avro")) {
                Assertions.assertThat((String)cloudEventRecord.valueSchema().name()).endsWith((CharSequence)".CloudEvents.Envelope");
                Assertions.assertThat((int)cloudEventRecord.valueSchema().fields().size()).isEqualTo(7);
                Assertions.assertThat((Comparable)cloudEventRecord.valueSchema().field("data").schema().type()).isEqualTo((Object)Schema.Type.STRUCT);
            }
            SinkRecord convertedRecord = transform.apply(cloudEventRecord);
            Assertions.assertThat((Object)convertedRecord).isNotNull();
            Assertions.assertThat((Object)convertedRecord).isNotEqualTo((Object)cloudEventRecord);
            Assertions.assertThat((Comparable)convertedRecord.valueSchema().type()).isEqualTo((Object)Schema.Type.STRUCT);
            Assertions.assertThat((int)convertedRecord.valueSchema().fields().size()).isEqualTo(7);
            Assertions.assertThat((Object)convertedRecord.value()).isInstanceOf(Struct.class);
            Struct convertedRecordValue = (Struct)convertedRecord.value();
            Assertions.assertThat((String)convertedRecordValue.getString("id")).isNotBlank();
            Assertions.assertThat((String)convertedRecordValue.getString("created_by")).isNotBlank();
            Assertions.assertThat((String)convertedRecordValue.getString("ce_spec_number")).isNotBlank();
            Assertions.assertThat((String)convertedRecordValue.getString("type")).isNotBlank();
            Assertions.assertThat((String)convertedRecordValue.getString("created_at")).isNotBlank();
            Assertions.assertThat((String)convertedRecordValue.getString("payload_format")).isNotBlank();
            Assertions.assertThat((String)convertedRecordValue.getString("payload")).isNotBlank();
            this.checkParamsOfOriginalAndConvertedRecordsAreEqual(cloudEventRecord, convertedRecord);
        }
    }

    private void checkParamsOfOriginalAndConvertedRecordsAreEqual(SinkRecord original, SinkRecord converted) {
        Assertions.assertThat((String)converted.topic()).isEqualTo((Object)original.topic());
        Assertions.assertThat((Integer)converted.kafkaPartition()).isEqualTo((Object)original.originalKafkaPartition());
        Assertions.assertThat((long)converted.kafkaOffset()).isEqualTo(original.originalKafkaOffset());
        Assertions.assertThat((Object)converted.keySchema()).isEqualTo((Object)original.keySchema());
        Assertions.assertThat((Object)converted.key()).isEqualTo(original.key());
        Assertions.assertThat((Iterable)converted.headers()).isEqualTo((Object)original.headers());
        Assertions.assertThat((Long)converted.timestamp()).isEqualTo((Object)original.timestamp());
    }
}

