/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.ColumnTransformers;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GeneratedColumn;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CannotForceNonNullableException;
import org.hibernate.cfg.IndexOrUniqueKeySecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.jboss.logging.Logger;

public class AnnotatedColumn {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AnnotatedColumn.class.getName());
    private MetadataBuildingContext context;
    private Column mappingColumn;
    private boolean insertable = true;
    private boolean updatable = true;
    private String explicitTableName;
    protected Map<String, Join> joins;
    protected PropertyHolder propertyHolder;
    private boolean isImplicit;
    public String sqlType;
    private Long length;
    private Integer precision;
    private Integer scale;
    private String logicalColumnName;
    private String propertyName;
    private boolean unique;
    private boolean nullable = true;
    private String formulaString;
    private org.hibernate.mapping.Formula formula;
    private Table table;
    private String readExpression;
    private String writeExpression;
    private String defaultValue;
    private String generatedAs;
    private String comment;
    private String checkConstraint;

    public void setTable(Table table) {
        this.table = table;
    }

    public String getLogicalColumnName() {
        return this.logicalColumnName;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public Long getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isFormula() {
        return StringHelper.isNotEmpty(this.formulaString);
    }

    public String getFormulaString() {
        return this.formulaString;
    }

    public String getExplicitTableName() {
        return this.explicitTableName;
    }

    public void setExplicitTableName(String explicitTableName) {
        this.explicitTableName = "``".equals(explicitTableName) ? "" : explicitTableName;
    }

    public void setFormula(String formula) {
        this.formulaString = formula;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    protected MetadataBuildingContext getBuildingContext() {
        return this.context;
    }

    public void setBuildingContext(MetadataBuildingContext context) {
        this.context = context;
    }

    public void setImplicit(boolean implicit) {
        this.isImplicit = implicit;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setLogicalColumnName(String logicalColumnName) {
        this.logicalColumnName = logicalColumnName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isNullable() {
        return this.isFormula() || this.mappingColumn.isNullable();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setCheckConstraint(String checkConstraint) {
        this.checkConstraint = checkConstraint;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getGeneratedAs() {
        return this.generatedAs;
    }

    private void setGeneratedAs(String as) {
        this.generatedAs = as;
    }

    public void bind() {
        if (StringHelper.isNotEmpty(this.formulaString)) {
            LOG.debugf("Binding formula %s", this.formulaString);
            this.formula = new org.hibernate.mapping.Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            this.initMappingColumn(this.logicalColumnName, this.propertyName, this.length, this.precision, this.scale, this.nullable, this.sqlType, this.unique, true);
            if (this.defaultValue != null) {
                this.mappingColumn.setDefaultValue(this.defaultValue);
            }
            if (this.checkConstraint != null) {
                this.mappingColumn.setCheckConstraint(this.checkConstraint);
            }
            if (StringHelper.isNotEmpty(this.comment)) {
                this.mappingColumn.setComment(this.comment);
            }
            if (this.generatedAs != null) {
                this.mappingColumn.setGeneratedAs(this.generatedAs);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding column: %s", this.toString());
            }
        }
    }

    protected void initMappingColumn(String columnName, String propertyName, Long length, Integer precision, Integer scale, boolean nullable, String sqlType, boolean unique, boolean applyNamingStrategy) {
        if (StringHelper.isNotEmpty(this.formulaString)) {
            this.formula = new org.hibernate.mapping.Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            int numberOfJdbcParams;
            this.mappingColumn = new Column();
            this.redefineColumnName(columnName, propertyName, applyNamingStrategy);
            this.mappingColumn.setLength(length);
            if (precision != null && precision > 0) {
                this.mappingColumn.setPrecision(precision);
                this.mappingColumn.setScale(scale);
            }
            this.mappingColumn.setNullable(nullable);
            this.mappingColumn.setSqlType(sqlType);
            this.mappingColumn.setUnique(unique);
            this.mappingColumn.setCheckConstraint(this.checkConstraint);
            if (this.writeExpression != null && (numberOfJdbcParams = StringHelper.count(this.writeExpression, '?')) != 1) {
                throw new AnnotationException("Write expression in '@ColumnTransformer' for property '" + propertyName + "' and column '" + this.logicalColumnName + "' must contain exactly one placeholder character ('?')");
            }
            this.mappingColumn.setResolvedCustomRead(this.readExpression);
            this.mappingColumn.setCustomWrite(this.writeExpression);
        }
    }

    public boolean isNameDeferred() {
        return this.mappingColumn == null || StringHelper.isEmpty(this.mappingColumn.getName());
    }

    public void redefineColumnName(String columnName, String propertyName, boolean applyNamingStrategy) {
        if (StringHelper.isNotEmpty(columnName)) {
            this.mappingColumn.setName(this.processColumnName(columnName, applyNamingStrategy));
        } else if (propertyName != null && applyNamingStrategy) {
            this.mappingColumn.setName(this.inferColumnName(propertyName));
        }
    }

    private String processColumnName(String columnName, boolean applyNamingStrategy) {
        if (applyNamingStrategy) {
            Database database = this.context.getMetadataCollector().getDatabase();
            return this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalColumnName(database.toIdentifier(columnName), database.getJdbcEnvironment()).render(database.getDialect());
        }
        return this.context.getObjectNameNormalizer().toDatabaseIdentifierText(columnName);
    }

    private String inferColumnName(final String propertyName) {
        ImplicitNamingStrategy implicitNamingStrategy;
        Database database = this.context.getMetadataCollector().getDatabase();
        ObjectNameNormalizer normalizer = this.context.getObjectNameNormalizer();
        Identifier implicitName = normalizer.normalizeIdentifierQuoting((implicitNamingStrategy = this.context.getBuildingOptions().getImplicitNamingStrategy()).determineBasicColumnName(new ImplicitBasicColumnNameSource(){
            final AttributePath attributePath;
            {
                this.attributePath = AttributePath.parse(propertyName);
            }

            @Override
            public AttributePath getAttributePath() {
                return this.attributePath;
            }

            @Override
            public boolean isCollectionElement() {
                return !AnnotatedColumn.this.propertyHolder.isComponent() && !AnnotatedColumn.this.propertyHolder.isEntity();
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return AnnotatedColumn.this.context;
            }
        }));
        if (implicitName.getText().contains("_collection&&element_")) {
            implicitName = Identifier.toIdentifier(implicitName.getText().replace("_collection&&element_", "_"), implicitName.isQuoted());
        }
        return this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalColumnName(implicitName, database.getJdbcEnvironment()).render(database.getDialect());
    }

    public String getName() {
        return this.mappingColumn.getName();
    }

    public Column getMappingColumn() {
        return this.mappingColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setNullable(boolean nullable) {
        if (this.mappingColumn != null) {
            this.mappingColumn.setNullable(nullable);
        } else {
            this.nullable = nullable;
        }
    }

    public void setJoins(Map<String, Join> joins) {
        this.joins = joins;
    }

    public PropertyHolder getPropertyHolder() {
        return this.propertyHolder;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    protected void setMappingColumn(Column mappingColumn) {
        this.mappingColumn = mappingColumn;
    }

    public void linkWithValue(SimpleValue value) {
        if (this.formula != null) {
            value.addFormula(this.formula);
        } else {
            this.table = value.getTable();
            this.getMappingColumn().setValue(value);
            value.addColumn(this.getMappingColumn(), this.insertable, this.updatable);
            this.table.addColumn(this.getMappingColumn());
            this.addColumnBinding(value);
        }
    }

    protected void addColumnBinding(SimpleValue value) {
        String logicalColumnName;
        if (StringHelper.isNotEmpty(this.logicalColumnName)) {
            logicalColumnName = this.logicalColumnName;
        } else {
            ObjectNameNormalizer normalizer = this.context.getObjectNameNormalizer();
            Database database = this.context.getMetadataCollector().getDatabase();
            ImplicitNamingStrategy implicitNamingStrategy = this.context.getBuildingOptions().getImplicitNamingStrategy();
            Identifier implicitName = normalizer.normalizeIdentifierQuoting(implicitNamingStrategy.determineBasicColumnName(new ImplicitBasicColumnNameSource(){

                @Override
                public AttributePath getAttributePath() {
                    return AttributePath.parse(AnnotatedColumn.this.propertyName);
                }

                @Override
                public boolean isCollectionElement() {
                    return false;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return AnnotatedColumn.this.context;
                }
            }));
            logicalColumnName = implicitName.render(database.getDialect());
        }
        this.context.getMetadataCollector().addColumnNameBinding(value.getTable(), logicalColumnName, this.getMappingColumn());
    }

    public Table getTable() {
        if (this.table != null) {
            return this.table;
        }
        if (this.isSecondary()) {
            return this.getJoin().getTable();
        }
        return this.propertyHolder.getTable();
    }

    public boolean isSecondary() {
        if (this.propertyHolder == null) {
            throw new AssertionFailure("Should not call getTable() on column w/o persistent class defined");
        }
        return StringHelper.isNotEmpty(this.explicitTableName) && !this.propertyHolder.getTable().getName().equals(this.explicitTableName);
    }

    public Join getJoin() {
        String physicalTableName;
        Join join = this.joins.get(this.explicitTableName);
        if (join == null && (physicalTableName = this.getBuildingContext().getMetadataCollector().getPhysicalTableName(this.explicitTableName)) != null) {
            join = this.joins.get(physicalTableName);
        }
        if (join == null) {
            throw new AnnotationException("Secondary table '" + this.explicitTableName + "' for property '" + this.propertyHolder.getClassName() + "' is not declared (use '@SecondaryTable' to declare the secondary table)");
        }
        return join;
    }

    public void forceNotNull() {
        if (this.mappingColumn == null) {
            throw new CannotForceNonNullableException("Cannot perform #forceNotNull because internal org.hibernate.mapping.Column reference is null: likely a formula");
        }
        this.mappingColumn.setNullable(false);
    }

    public static AnnotatedColumn[] buildFormulaFromAnnotation(Formula formulaAnn, Comment commentAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnOrFormulaFromAnnotation(null, formulaAnn, commentAnn, nullability, propertyHolder, inferredData, secondaryTables, context);
    }

    public static AnnotatedColumn[] buildColumnFromNoAnnotation(Comment commentAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsFromAnnotations(null, commentAnn, nullability, propertyHolder, inferredData, secondaryTables, context);
    }

    public static AnnotatedColumn[] buildColumnFromAnnotation(jakarta.persistence.Column column, Comment commentAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnOrFormulaFromAnnotation(column, null, commentAnn, nullability, propertyHolder, inferredData, secondaryTables, context);
    }

    public static AnnotatedColumn[] buildColumnsFromAnnotations(jakarta.persistence.Column[] columns, Comment commentAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsOrFormulaFromAnnotation(columns, null, commentAnn, nullability, propertyHolder, inferredData, null, secondaryTables, context);
    }

    public static AnnotatedColumn[] buildColumnsFromAnnotations(jakarta.persistence.Column[] columns, Comment commentAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsOrFormulaFromAnnotation(columns, null, commentAnn, nullability, propertyHolder, inferredData, suffixForDefaultColumnName, secondaryTables, context);
    }

    public static AnnotatedColumn[] buildColumnOrFormulaFromAnnotation(jakarta.persistence.Column column, Formula formulaAnn, Comment commentAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsOrFormulaFromAnnotation(new jakarta.persistence.Column[]{column}, formulaAnn, commentAnn, nullability, propertyHolder, inferredData, null, secondaryTables, context);
    }

    public static AnnotatedColumn[] buildColumnsOrFormulaFromAnnotation(jakarta.persistence.Column[] columnAnns, Formula formulaAnn, Comment comment, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        if (formulaAnn != null) {
            AnnotatedColumn formulaColumn = new AnnotatedColumn();
            formulaColumn.setFormula(formulaAnn.value());
            formulaColumn.setImplicit(false);
            formulaColumn.setBuildingContext(context);
            formulaColumn.setPropertyHolder(propertyHolder);
            formulaColumn.bind();
            return new AnnotatedColumn[]{formulaColumn};
        }
        jakarta.persistence.Column[] actualCols = AnnotatedColumn.overrideColumns(columnAnns, propertyHolder, inferredData);
        if (actualCols == null) {
            return AnnotatedColumn.buildImplicitColumn(inferredData, suffixForDefaultColumnName, secondaryTables, propertyHolder, comment, nullability, context);
        }
        return AnnotatedColumn.buildExplicitColumns(comment, propertyHolder, inferredData, suffixForDefaultColumnName, secondaryTables, context, actualCols);
    }

    private static jakarta.persistence.Column[] overrideColumns(jakarta.persistence.Column[] columnAnns, PropertyHolder propertyHolder, PropertyData inferredData) {
        jakarta.persistence.Column[] overriddenCols = propertyHolder.getOverriddenColumn(StringHelper.qualify(propertyHolder.getPath(), inferredData.getPropertyName()));
        if (overriddenCols != null) {
            if (columnAnns != null && overriddenCols.length != columnAnns.length) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' specifies " + columnAnns.length + " '@AttributeOverride's but the overridden property has " + overriddenCols.length + " columns (every column must have exactly one '@AttributeOverride')");
            }
            LOG.debugf("Column(s) overridden for property %s", inferredData.getPropertyName());
            return overriddenCols.length == 0 ? null : overriddenCols;
        }
        return columnAnns;
    }

    private static AnnotatedColumn[] buildExplicitColumns(Comment comment, PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context, jakarta.persistence.Column[] actualCols) {
        int length = actualCols.length;
        AnnotatedColumn[] columns = new AnnotatedColumn[length];
        for (int index = 0; index < length; ++index) {
            jakarta.persistence.Column column = actualCols[index];
            Database database = context.getMetadataCollector().getDatabase();
            String sqlType = column.columnDefinition().isEmpty() ? null : context.getObjectNameNormalizer().applyGlobalQuoting(column.columnDefinition());
            String tableName = StringHelper.isEmpty(column.table()) ? "" : database.getJdbcEnvironment().getIdentifierHelper().toIdentifier(column.table()).render();
            columns[index] = AnnotatedColumn.buildColumn(comment, propertyHolder, inferredData, suffixForDefaultColumnName, secondaryTables, context, length, database, column, sqlType, tableName);
        }
        return columns;
    }

    private static AnnotatedColumn buildColumn(Comment comment, PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context, int length, Database database, jakarta.persistence.Column col, String sqlType, String tableName) {
        AnnotatedColumn column = new AnnotatedColumn();
        column.setLogicalColumnName(AnnotatedColumn.getLogicalColumnName(inferredData, suffixForDefaultColumnName, database, col));
        column.setImplicit(false);
        column.setSqlType(sqlType);
        column.setLength(Long.valueOf(col.length()));
        column.setPrecision(col.precision());
        column.setScale(col.scale());
        column.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
        column.setNullable(col.nullable());
        if (comment != null) {
            column.setComment(comment.value());
        }
        column.setUnique(col.unique());
        column.setInsertable(col.insertable());
        column.setUpdatable(col.updatable());
        column.setExplicitTableName(tableName);
        column.setPropertyHolder(propertyHolder);
        column.setJoins(secondaryTables);
        column.setBuildingContext(context);
        column.applyColumnDefault(inferredData, length);
        column.applyGeneratedAs(inferredData, length);
        column.applyCheckConstraint(inferredData, length);
        column.extractDataFromPropertyData(inferredData);
        column.bind();
        return column;
    }

    private static String getLogicalColumnName(PropertyData inferredData, String suffixForDefaultColumnName, Database database, jakarta.persistence.Column column) {
        String columnName = column.name() != null && column.name().isEmpty() ? null : database.getJdbcEnvironment().getIdentifierHelper().toIdentifier(column.name()).render();
        return StringHelper.isEmpty(columnName) && !StringHelper.isEmpty(suffixForDefaultColumnName) ? inferredData.getPropertyName() + suffixForDefaultColumnName : columnName;
    }

    private void applyColumnDefault(PropertyData inferredData, int length) {
        XProperty xProperty = inferredData.getProperty();
        if (xProperty != null) {
            ColumnDefault columnDefault = BinderHelper.getOverridableAnnotation((XAnnotatedElement)xProperty, ColumnDefault.class, this.context);
            if (columnDefault != null) {
                if (length != 1) {
                    throw new MappingException("@ColumnDefault may only be applied to single-column mappings");
                }
                this.setDefaultValue(columnDefault.value());
            }
        } else {
            LOG.trace("Could not perform @ColumnDefault lookup as 'PropertyData' did not give access to XProperty");
        }
    }

    private void applyGeneratedAs(PropertyData inferredData, int length) {
        XProperty xProperty = inferredData.getProperty();
        if (xProperty != null) {
            GeneratedColumn generatedColumn = BinderHelper.getOverridableAnnotation((XAnnotatedElement)xProperty, GeneratedColumn.class, this.context);
            if (generatedColumn != null) {
                if (length != 1) {
                    throw new MappingException("@GeneratedColumn may only be applied to single-column mappings");
                }
                this.setGeneratedAs(generatedColumn.value());
            }
        } else {
            LOG.trace("Could not perform @GeneratedColumn lookup as 'PropertyData' did not give access to XProperty");
        }
    }

    private void applyCheckConstraint(PropertyData inferredData, int length) {
        XProperty xProperty = inferredData.getProperty();
        if (xProperty != null) {
            Check check = BinderHelper.getOverridableAnnotation((XAnnotatedElement)xProperty, Check.class, this.context);
            if (check != null) {
                if (length != 1) {
                    throw new MappingException("@Check may only be applied to single-column mappings (use a table-level @Check)");
                }
                this.setCheckConstraint(check.constraints());
            }
        } else {
            LOG.trace("Could not perform @Check lookup as 'PropertyData' did not give access to XProperty");
        }
    }

    private void extractDataFromPropertyData(PropertyData inferredData) {
        XProperty property;
        if (inferredData != null && (property = inferredData.getProperty()) != null) {
            if (this.propertyHolder.isComponent()) {
                this.processColumnTransformerExpressions(this.propertyHolder.getOverriddenColumnTransformer(this.logicalColumnName));
            }
            this.processColumnTransformerExpressions((ColumnTransformer)property.getAnnotation(ColumnTransformer.class));
            ColumnTransformers annotations = (ColumnTransformers)property.getAnnotation(ColumnTransformers.class);
            if (annotations != null) {
                for (ColumnTransformer annotation : annotations.value()) {
                    this.processColumnTransformerExpressions(annotation);
                }
            }
        }
    }

    private void processColumnTransformerExpressions(ColumnTransformer annotation) {
        if (annotation != null && (StringHelper.isEmpty(annotation.forColumn()) || annotation.forColumn().equals(this.logicalColumnName != null ? this.logicalColumnName : ""))) {
            this.readExpression = StringHelper.nullIfEmpty(annotation.read());
            this.writeExpression = StringHelper.nullIfEmpty(annotation.write());
        }
    }

    private static AnnotatedColumn[] buildImplicitColumn(PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, Comment comment, Nullability nullability, MetadataBuildingContext context) {
        AnnotatedColumn[] columns = new AnnotatedColumn[]{AnnotatedColumn.bindImplicitColumn(inferredData, suffixForDefaultColumnName, secondaryTables, propertyHolder, comment, nullability, context)};
        return columns;
    }

    private static AnnotatedColumn bindImplicitColumn(PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, Comment comment, Nullability nullability, MetadataBuildingContext context) {
        AnnotatedColumn column = new AnnotatedColumn();
        if (comment != null) {
            column.setComment(comment.value());
        }
        if (nullability != Nullability.FORCED_NULL && inferredData.getClassOrElement().isPrimitive() && !inferredData.getProperty().isArray()) {
            column.setNullable(false);
        }
        String propertyName = inferredData.getPropertyName();
        column.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        column.setPropertyHolder(propertyHolder);
        column.setJoins(secondaryTables);
        column.setBuildingContext(context);
        boolean implicit = StringHelper.isEmpty(suffixForDefaultColumnName);
        if (!implicit) {
            column.setLogicalColumnName(propertyName + suffixForDefaultColumnName);
        }
        column.setImplicit(implicit);
        column.applyColumnDefault(inferredData, 1);
        column.applyGeneratedAs(inferredData, 1);
        column.applyCheckConstraint(inferredData, 1);
        column.extractDataFromPropertyData(inferredData);
        column.bind();
        return column;
    }

    public static void checkPropertyConsistency(AnnotatedColumn[] columns, String propertyName) {
        int nbrOfColumns = columns.length;
        if (nbrOfColumns > 1) {
            for (int currentIndex = 1; currentIndex < nbrOfColumns; ++currentIndex) {
                if (columns[currentIndex].isFormula() || columns[currentIndex - 1].isFormula()) continue;
                if (columns[currentIndex].isNullable() != columns[currentIndex - 1].isNullable()) {
                    throw new AnnotationException("Column mappings for property '" + propertyName + "' mix nullable with 'not null'");
                }
                if (columns[currentIndex].isInsertable() != columns[currentIndex - 1].isInsertable()) {
                    throw new AnnotationException("Column mappings for property '" + propertyName + "' mix insertable with 'insertable=false'");
                }
                if (columns[currentIndex].isUpdatable() != columns[currentIndex - 1].isUpdatable()) {
                    throw new AnnotationException("Column mappings for property '" + propertyName + "' mix updatable with 'updatable=false'");
                }
                if (columns[currentIndex].getTable().equals(columns[currentIndex - 1].getTable())) continue;
                throw new AnnotationException("Column mappings for property '" + propertyName + "' mix distinct secondary tables");
            }
        }
    }

    public void addIndex(Index index, boolean inSecondPass) {
        if (index != null) {
            this.addIndex(index.name(), inSecondPass);
        }
    }

    void addIndex(String indexName, boolean inSecondPass) {
        IndexOrUniqueKeySecondPass secondPass = new IndexOrUniqueKeySecondPass(indexName, this, this.context, false);
        if (inSecondPass) {
            secondPass.doSecondPass(this.context.getMetadataCollector().getEntityBindingMap());
        } else {
            this.context.getMetadataCollector().addSecondPass(secondPass);
        }
    }

    void addUniqueKey(String uniqueKeyName, boolean inSecondPass) {
        IndexOrUniqueKeySecondPass secondPass = new IndexOrUniqueKeySecondPass(uniqueKeyName, this, this.context, true);
        if (inSecondPass) {
            secondPass.doSecondPass(this.context.getMetadataCollector().getEntityBindingMap());
        } else {
            this.context.getMetadataCollector().addSecondPass(secondPass);
        }
    }

    public String toString() {
        return String.format("Column{table=%s, mappingColumn=%s, insertable=%s, updatable=%s, unique=%s}", this.getTable(), this.mappingColumn.getName(), this.insertable, this.updatable, this.unique);
    }
}

