/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.QueryBinder;
import io.debezium.connector.jdbc.QueryBinderResolver;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Struct;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;

public class RecordWriter {
    private final SharedSessionContract session;
    private final QueryBinderResolver queryBinderResolver;
    private final JdbcSinkConnectorConfig config;
    private final DatabaseDialect dialect;

    public RecordWriter(SharedSessionContract session, QueryBinderResolver queryBinderResolver, JdbcSinkConnectorConfig config, DatabaseDialect dialect) {
        this.session = session;
        this.queryBinderResolver = queryBinderResolver;
        this.config = config;
        this.dialect = dialect;
    }

    public void write(List<SinkRecordDescriptor> records, String sqlStatement) {
        Transaction transaction = this.session.beginTransaction();
        try {
            this.session.doWork(this.processBatch(records, sqlStatement));
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }

    private Work processBatch(List<SinkRecordDescriptor> records, String sqlStatement) {
        return conn -> {
            try (PreparedStatement prepareStatement = conn.prepareStatement(sqlStatement);){
                int[] batchResult;
                QueryBinder queryBinder = this.queryBinderResolver.resolve(prepareStatement);
                for (SinkRecordDescriptor sinkRecordDescriptor : records) {
                    this.bindValues(sinkRecordDescriptor, queryBinder);
                    prepareStatement.addBatch();
                }
                for (int updateCount : batchResult = prepareStatement.executeBatch()) {
                    if (updateCount != -3) continue;
                    throw new BatchUpdateException("Execution failed for part of the batch", batchResult);
                }
            }
        };
    }

    private void bindValues(SinkRecordDescriptor sinkRecordDescriptor, QueryBinder queryBinder) {
        if (sinkRecordDescriptor.isDelete()) {
            this.bindKeyValuesToQuery(sinkRecordDescriptor, queryBinder, 1);
            return;
        }
        switch (this.config.getInsertMode()) {
            case INSERT: 
            case UPSERT: {
                int index = this.bindKeyValuesToQuery(sinkRecordDescriptor, queryBinder, 1);
                this.bindNonKeyValuesToQuery(sinkRecordDescriptor, queryBinder, index);
                break;
            }
            case UPDATE: {
                int index = this.bindNonKeyValuesToQuery(sinkRecordDescriptor, queryBinder, 1);
                this.bindKeyValuesToQuery(sinkRecordDescriptor, queryBinder, index);
            }
        }
    }

    private int bindKeyValuesToQuery(SinkRecordDescriptor record, QueryBinder query, int index) {
        if (Objects.requireNonNull(this.config.getPrimaryKeyMode()) == JdbcSinkConnectorConfig.PrimaryKeyMode.KAFKA) {
            query.bind(new ValueBindDescriptor(index++, record.getTopicName()));
            query.bind(new ValueBindDescriptor(index++, record.getPartition()));
            query.bind(new ValueBindDescriptor(index++, record.getOffset()));
        } else {
            Struct keySource = record.getKeyStruct(this.config.getPrimaryKeyMode());
            if (keySource != null) {
                index = this.bindFieldValuesToQuery(record, query, index, keySource, record.getKeyFieldNames());
            }
        }
        return index;
    }

    private int bindNonKeyValuesToQuery(SinkRecordDescriptor record, QueryBinder query, int index) {
        return this.bindFieldValuesToQuery(record, query, index, record.getAfterStruct(), record.getNonKeyFieldNames());
    }

    private int bindFieldValuesToQuery(SinkRecordDescriptor record, QueryBinder query, int index, Struct source, List<String> fields) {
        for (String fieldName : fields) {
            SinkRecordDescriptor.FieldDescriptor field = record.getFields().get(fieldName);
            Object value = field.getSchema().isOptional() ? source.getWithoutDefault(fieldName) : source.get(fieldName);
            List<ValueBindDescriptor> boundValues = this.dialect.bindValue(field, index, value);
            boundValues.forEach(query::bind);
            index += boundValues.size();
        }
        return index;
    }
}

