/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.transforms.ConvertCloudEventToSaveableForm;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.converters.spi.SerializerType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.ValueType;
import org.fest.assertions.Assertions;
import org.fest.assertions.Index;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public abstract class AbstractJdbcSinkSaveConvertedCloudEventTest
extends AbstractJdbcSinkTest {
    public AbstractJdbcSinkSaveConvertedCloudEventTest(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testSaveConvertedCloudEventRecordFromJson(SinkRecordFactory factory) {
        ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("fields.mapping", "id,source:created_by,data:payload");
        config.put("serializer.type", "json");
        transform.configure(config);
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord cloudEventRecord = factory.cloudEventRecord(topicName, SerializerType.withName((String)"json"));
        SinkRecord convertedRecord = transform.apply(cloudEventRecord);
        this.consume(convertedRecord);
        String destinationTableName = this.destinationTableName(convertedRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "created_by", ValueType.TEXT, "test_ce_source");
        this.getSink().assertColumnType(tableAssert, "payload", ValueType.TEXT);
        this.assertHasPrimaryKeyColumns(destinationTableName, "id");
        transform.close();
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testSaveConvertedCloudEventRecordFromAvro(SinkRecordFactory factory) {
        ConvertCloudEventToSaveableForm transform = new ConvertCloudEventToSaveableForm();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("fields.mapping", "id,source:created_by,data:payload");
        config.put("serializer.type", "avro");
        transform.configure(config);
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord cloudEventRecord = factory.cloudEventRecord(topicName, SerializerType.withName((String)"avro"));
        SinkRecord convertedRecord = transform.apply(cloudEventRecord);
        this.consume(convertedRecord);
        String destinationTableName = this.destinationTableName(convertedRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "created_by", ValueType.TEXT, "test_ce_source");
        this.getSink().assertColumnType(tableAssert, "payload", ValueType.TEXT);
        this.assertHasPrimaryKeyColumns(destinationTableName, "id");
        transform.close();
    }

    protected void assertHasPrimaryKeyColumns(String tableName, String ... columnNames) {
        this.assertHasPrimaryKeyColumns(tableName, true, columnNames);
    }

    protected void assertHasPrimaryKeyColumns(String tableName, boolean caseInsensitive, String ... columnNames) {
        List<String> pkColumnNames = TestHelper.getPrimaryKeyColumnNames(this.dataSource(), tableName);
        if (columnNames.length == 0) {
            Assertions.assertThat(pkColumnNames).isEmpty();
        } else if (caseInsensitive) {
            pkColumnNames = pkColumnNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
                Assertions.assertThat(pkColumnNames).contains((Object)columnNames[columnIndex].toLowerCase(), Index.atIndex((int)columnIndex));
            }
        } else {
            Assertions.assertThat(pkColumnNames).containsExactly((Object[])columnNames);
        }
    }
}

