/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.sql.results.graph.Fetchable;

public interface FetchableContainer
extends ModelPartContainer {
    default public int getNumberOfKeyFetchables() {
        return 0;
    }

    public int getNumberOfFetchables();

    default public Fetchable getKeyFetchable(int position) {
        ArrayList fetchables = new ArrayList(this.getNumberOfKeyFetchables());
        this.visitKeyFetchables((Fetchable fetchable) -> fetchables.add(fetchable), null);
        return (Fetchable)fetchables.get(position);
    }

    default public Fetchable getFetchable(int position) {
        ArrayList fetchables = new ArrayList(this.getNumberOfFetchables());
        this.visitFetchables((Fetchable fetchable) -> fetchables.add(fetchable), null);
        return (Fetchable)fetchables.get(position);
    }

    default public void visitKeyFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
    }

    default public void visitKeyFetchables(IndexedConsumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.visitKeyFetchables(0, fetchableConsumer, treatTargetType);
    }

    default public void visitKeyFetchables(int offset, IndexedConsumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
    }

    default public void visitFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.visitSubParts(fetchableConsumer, treatTargetType);
    }

    default public void visitFetchables(IndexedConsumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.visitFetchables(0, fetchableConsumer, treatTargetType);
    }

    default public void visitFetchables(int offset, IndexedConsumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        MutableInteger index = new MutableInteger(offset);
        this.visitSubParts(modelPart -> fetchableConsumer.accept(index.getAndIncrement(), (Fetchable)modelPart), treatTargetType);
    }
}

