/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Tuple;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.query.BindableType;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.criteria.internal.NamedCriteriaQueryMementoImpl;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.internal.DelegatingDomainQueryExecutionContext;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.SqmSelectionQuery;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.results.internal.TupleMetadata;

public class SqmSelectionQueryImpl<R>
extends AbstractSelectionQuery<R>
implements SqmSelectionQuery<R>,
SqmInterpretationsKey.InterpretationsKeySource {
    private final String hql;
    private final SqmSelectStatement<R> sqm;
    private final ParameterMetadataImplementor parameterMetadata;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindingsImpl parameterBindings;
    private final Class<R> resultType;
    private final TupleMetadata tupleMetadata;

    public SqmSelectionQueryImpl(String hql, HqlInterpretation hqlInterpretation, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = hql;
        this.sqm = (SqmSelectStatement)hqlInterpretation.getSqmStatement();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        this.resultType = SqmSelectionQueryImpl.determineResultType(this.sqm, expectedResultType);
        this.setComment(hql);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, expectedResultType);
    }

    private static <T> Class<T> determineResultType(SqmSelectStatement<?> sqm, Class<?> expectedResultType) {
        List<SqmSelection<?>> selections;
        if (expectedResultType != null && expectedResultType.equals(Tuple.class)) {
            return Tuple.class;
        }
        if (!(expectedResultType != null && expectedResultType.isArray() || (selections = ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections()).size() != 1)) {
            SqmSelection<?> sqmSelection = selections.get(0);
            return sqmSelection.getNodeJavaType().getJavaTypeClass();
        }
        return Object[].class;
    }

    public SqmSelectionQueryImpl(NamedHqlQueryMementoImpl memento, Class<R> resultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = memento.getHqlString();
        this.resultType = resultType;
        SessionFactoryImplementor factory = session.getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        HqlInterpretation hqlInterpretation = interpretationCache.resolveHqlInterpretation(this.hql, resultType, s -> queryEngine.getHqlTranslator().translate(this.hql, resultType));
        SqmUtil.verifyIsSelectStatement(hqlInterpretation.getSqmStatement(), this.hql);
        this.sqm = (SqmSelectStatement)hqlInterpretation.getSqmStatement();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        this.setComment(this.hql);
        this.applyOptions(memento);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, resultType);
    }

    public SqmSelectionQueryImpl(NamedCriteriaQueryMementoImpl memento, Class<R> resultType, SharedSessionContractImplementor session) {
        this((SqmSelectStatement)memento.getSqmStatement(), resultType, session);
        this.applyOptions(memento);
    }

    public SqmSelectionQueryImpl(SqmSelectStatement<R> criteria, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(session);
        this.hql = "<criteria>";
        this.sqm = session.isCriteriaCopyTreeEnabled() ? criteria.copy(SqmCopyContext.simpleContext()) : criteria;
        this.domainParameterXref = DomainParameterXref.from(this.sqm);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        for (SqmParameter<?> sqmParameter : this.domainParameterXref.getParameterResolutions().getSqmParameters()) {
            JpaCriteriaParameter jpaCriteriaParameter;
            Object value;
            if (!(sqmParameter instanceof SqmJpaCriteriaParameterWrapper) || (value = (jpaCriteriaParameter = ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter()).getValue()) == null && jpaCriteriaParameter.getNodeType() != null) continue;
            this.getQueryParameterBindings().getBinding(jpaCriteriaParameter).setBindValue(value, jpaCriteriaParameter.getAnticipatedType());
        }
        this.resultType = SqmSelectionQueryImpl.determineResultType(this.sqm, expectedResultType);
        this.visitQueryReturnType(this.sqm.getQueryPart(), expectedResultType, this.getSessionFactory());
        this.setComment(this.hql);
        this.tupleMetadata = this.buildTupleMetadata(this.sqm, expectedResultType);
    }

    @Override
    public SqmSelectStatement getSqmStatement() {
        return this.sqm;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public String getQueryString() {
        return this.hql;
    }

    @Override
    protected void prepareForExecution() {
        this.resetCallback();
    }

    @Override
    protected List<R> doList() {
        DomainQueryExecutionContext executionContextToUse;
        boolean needsDistinct;
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        SqmSelectStatement sqmStatement = this.getSqmStatement();
        boolean containsCollectionFetches = sqmStatement.containsCollectionFetches();
        boolean hasLimit = SqmSelectionQueryImpl.hasLimit(sqmStatement, (MutableQueryOptions)this.getQueryOptions());
        boolean bl = needsDistinct = containsCollectionFetches && (sqmStatement.usesDistinct() || SqmSelectionQueryImpl.hasAppliedGraph((MutableQueryOptions)this.getQueryOptions()) || hasLimit);
        if (hasLimit && containsCollectionFetches) {
            boolean fail = this.getSessionFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled();
            if (fail) {
                throw new HibernateException("firstResult/maxResults specified with collection fetch. In memory pagination was about to be applied. Failing because 'Fail on pagination over collection fetch' is enabled.");
            }
            QueryLogging.QUERY_MESSAGE_LOGGER.firstOrMaxResultsSpecifiedWithCollectionFetch();
            QueryOptions originalQueryOptions = this.getQueryOptions();
            final QueryOptions normalizedQueryOptions = SqlOmittingQueryOptions.omitSqlQueryOptions(originalQueryOptions, true, false);
            executionContextToUse = originalQueryOptions == normalizedQueryOptions ? this : new DelegatingDomainQueryExecutionContext(this){

                @Override
                public QueryOptions getQueryOptions() {
                    return normalizedQueryOptions;
                }
            };
        } else {
            executionContextToUse = this;
        }
        List<R> list = this.resolveQueryPlan().performList(executionContextToUse);
        if (needsDistinct) {
            int includedCount = -1;
            int first = !hasLimit || this.getQueryOptions().getLimit().getFirstRow() == null ? this.getIntegerLiteral(sqmStatement.getOffset(), 0) : this.getQueryOptions().getLimit().getFirstRow().intValue();
            int max = !hasLimit || this.getQueryOptions().getLimit().getMaxRows() == null ? this.getMaxRows(sqmStatement, list.size()) : this.getQueryOptions().getLimit().getMaxRows().intValue();
            ArrayList<R> tmp = new ArrayList<R>(list.size());
            IdentitySet<R> distinction = new IdentitySet<R>(list.size());
            for (R result : list) {
                if (!distinction.add(result) || ++includedCount < first) continue;
                tmp.add(result);
                if (max < 0 || includedCount - first < max - 1) continue;
                break;
            }
            return tmp;
        }
        return list;
    }

    @Override
    protected ScrollableResultsImplementor<R> doScroll(ScrollMode scrollMode) {
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        return this.resolveQueryPlan().performScroll(scrollMode, this);
    }

    private SelectQueryPlan<R> resolveQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey(this);
        if (cacheKey != null) {
            return this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, this::buildQueryPlan);
        }
        return this.buildQueryPlan();
    }

    private SelectQueryPlan<R> buildQueryPlan() {
        SqmSelectStatement<R>[] concreteSqmStatements = QuerySplitter.split(this.getSqmStatement(), this.getSession().getFactory());
        if (concreteSqmStatements.length > 1) {
            return this.buildAggregatedQueryPlan(concreteSqmStatements);
        }
        return this.buildConcreteQueryPlan(concreteSqmStatements[0], this.getResultType(), this.getQueryOptions());
    }

    private SelectQueryPlan<R> buildAggregatedQueryPlan(SqmSelectStatement<?>[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteQueryPlan(concreteSqmStatements[i], this.getResultType(), this.getQueryOptions());
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private <T> SelectQueryPlan<T> buildConcreteQueryPlan(SqmSelectStatement<?> concreteSqmStatement, Class<T> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<T>(concreteSqmStatement, this.getQueryString(), this.getDomainParameterXref(), resultType, this.tupleMetadata, queryOptions);
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.getSession().getLoadQueryInfluencers();
    }

    @Override
    public Supplier<Boolean> hasMultiValuedParameterBindingsChecker() {
        return this::hasMultiValuedParameterBindings;
    }

    protected boolean hasMultiValuedParameterBindings() {
        return this.getQueryParameterBindings().hasAnyMultiValuedBindings() || this.getParameterMetadata().hasAnyMatching(QueryParameter::allowsMultiValuedBinding);
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return false;
    }

    @Override
    public FlushModeType getFlushMode() {
        return FlushModeTypeHelper.getFlushModeType(this.getQueryOptions().getFlushMode());
    }

    @Override
    public SqmSelectionQuery<R> setFlushMode(FlushModeType flushMode) {
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushMode));
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    @Override
    public SqmSelectionQuery<R> setLockMode(LockModeType lockMode) {
        this.setHibernateLockMode(LockModeTypeHelper.getLockMode(lockMode));
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setHibernateLockMode(LockMode lockMode) {
        this.getLockOptions().setLockMode(lockMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setAliasSpecificLockMode(String alias, LockMode lockMode) {
        this.getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setFollowOnLocking(boolean enable) {
        this.getLockOptions().setFollowOnLocking(enable);
        return this;
    }

    @Override
    public Integer getFetchSize() {
        return this.getQueryOptions().getFetchSize();
    }

    @Override
    public SqmSelectionQuery<R> setFetchSize(int fetchSize) {
        this.getQueryOptions().setFetchSize(fetchSize);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.getQueryOptions().isReadOnly() == null ? this.getSession().isDefaultReadOnly() : this.getQueryOptions().isReadOnly().booleanValue();
    }

    @Override
    public SqmSelectionQuery<R> setReadOnly(boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.getQueryOptions().getCacheMode();
    }

    @Override
    public SqmSelectionQuery<R> setCacheMode(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
    }

    @Override
    public SqmSelectionQuery<R> setCacheable(boolean cacheable) {
        this.getQueryOptions().setResultCachingEnabled(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.getQueryOptions().getResultCacheRegionName();
    }

    @Override
    public SqmSelectionQuery<R> setCacheRegion(String regionName) {
        this.getQueryOptions().setResultCacheRegionName(regionName);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        AppliedGraph appliedGraph;
        super.collectHints(hints);
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getFetchSize());
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if ((appliedGraph = this.getQueryOptions().getAppliedGraph()) != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph);
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph);
        }
        this.putIfNotNull(hints, "hibernate.query.followOnLocking", this.getQueryOptions().getLockOptions().getFollowOnLocking());
    }

    @Override
    public SqmSelectionQuery<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaType);
        return this;
    }

    @Override
    public <P> SqmSelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public SqmSelectionQuery<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }
}

