/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter.e2e.source;

public enum SourceType {
    MYSQL("mysql"),
    POSTGRES("postgres"),
    SQLSERVER("sqlserver"),
    ORACLE("oracle");

    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean is(SourceType ... types) {
        for (SourceType type : types) {
            if (type != this) continue;
            return true;
        }
        return false;
    }

    public static SourceType parse(String value) {
        for (SourceType type : SourceType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalStateException("Unknown source type: " + value);
    }
}

