/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter;

import io.debezium.connector.jdbc.junit.jupiter.JdbcConnectionProvider;
import io.debezium.connector.jdbc.junit.jupiter.SinkType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.assertj.db.api.AbstractColumnAssert;
import org.assertj.db.api.TableAssert;
import org.assertj.db.api.TableColumnAssert;
import org.assertj.db.type.ValueType;
import org.fest.assertions.Assertions;
import org.fest.assertions.StringAssert;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.ThrowingFunction;

public class Sink
extends JdbcConnectionProvider {
    private final SinkType type;

    public Sink(SinkType sinkType, JdbcDatabaseContainer<?> database) {
        super(database, new SinkConnectionInitializer(sinkType));
        this.type = sinkType;
    }

    public SinkType getType() {
        return this.type;
    }

    public String getJdbcUrl() {
        if (SinkType.SQLSERVER == this.type) {
            return this.getContainer().getJdbcUrl() + ";databaseName=testDB";
        }
        return this.getContainer().getJdbcUrl();
    }

    public String formatTableName(String tableName) {
        if (this.type.is(SinkType.ORACLE, SinkType.DB2)) {
            return tableName.toUpperCase();
        }
        return tableName;
    }

    public String formatColumnName(String columnName) {
        if (this.type.is(SinkType.ORACLE, SinkType.DB2)) {
            return columnName.toUpperCase();
        }
        return columnName;
    }

    public AbstractColumnAssert assertColumnType(TableAssert table, String columnName, ValueType type, boolean lenient) {
        return ((TableColumnAssert)table.column(columnName)).isOfType(type, lenient);
    }

    public AbstractColumnAssert assertColumnType(TableAssert table, String columnName, Class classType, Object values) {
        return ((TableColumnAssert)((TableColumnAssert)table.column(columnName)).isOfClass(classType, false)).hasValues(new Object[]{values});
    }

    public void assertColumnType(TableAssert table, String columnName, ValueType type) {
        this.assertColumnType(table, columnName, type, false);
    }

    public void assertColumnType(TableAssert table, String columnName, ValueType type, Number ... values) {
        this.assertColumnType(table, columnName, type, this.isAnyValueNull(values)).hasValues(values);
    }

    public void assertColumnType(TableAssert table, String columnName, ValueType type, String ... values) {
        this.assertColumnType(table, columnName, type, this.isAnyValueNull(values)).hasValues(values);
    }

    public void assertColumnType(TableAssert table, String columnName, ValueType type, byte[] ... values) {
        this.assertColumnType(table, columnName, type, this.isAnyValueNull((T[])values)).hasValues(values);
    }

    public void assertColumnHasNullValue(TableAssert table, String columnName) {
        this.assertColumnType(table, columnName, ValueType.NOT_IDENTIFIED, false).hasOnlyNullValues();
    }

    public void assertColumn(String tableName, String columnName, String expectedType) {
        tableName = this.formatTableName(tableName);
        columnName = this.formatColumnName(columnName);
        try (ResultSet rs = this.getConnection().getMetaData().getColumns(null, null, tableName, columnName);){
            if (rs.next()) {
                ((StringAssert)Assertions.assertThat((String)rs.getString(6)).as(String.format("Column %s", columnName))).isEqualToIgnoringCase(expectedType);
                return;
            }
            throw new AssertionError((Object)String.format("Column %s not found in table %s.", columnName, tableName));
        }
        catch (SQLException e) {
            throw new AssertionError(String.format("Failed to get column %s in table %s", columnName, tableName), e);
        }
    }

    public void assertColumn(String tableName, String columnName, String expectedType, int length) {
        tableName = this.formatTableName(tableName);
        columnName = this.formatColumnName(columnName);
        try (ResultSet rs = this.getConnection().getMetaData().getColumns(null, null, tableName, columnName);){
            if (rs.next()) {
                Assertions.assertThat((String)rs.getString(6)).isEqualToIgnoringCase(expectedType);
                Assertions.assertThat((int)rs.getInt(7)).isEqualTo(length);
                return;
            }
            throw new AssertionError((Object)String.format("Column %s not found in table %s.", columnName, tableName));
        }
        catch (SQLException e) {
            throw new AssertionError(String.format("Failed to get column %s in table %s", columnName, tableName), e);
        }
    }

    public void assertColumn(String tableName, String columnName, String expectedType, int precision, int scale) {
        tableName = this.formatTableName(tableName);
        columnName = this.formatColumnName(columnName);
        try (ResultSet rs = this.getConnection().getMetaData().getColumns(null, null, tableName, columnName);){
            if (rs.next()) {
                Assertions.assertThat((String)rs.getString(6)).isEqualToIgnoringCase(expectedType);
                Assertions.assertThat((int)rs.getInt(7)).isEqualTo(precision);
                Assertions.assertThat((int)rs.getInt(9)).isEqualTo(scale);
                return;
            }
            throw new AssertionError((Object)String.format("Column %s not found in table %s.", columnName, tableName));
        }
        catch (SQLException e) {
            throw new AssertionError(String.format("Failed to get column %s in table %s", columnName, tableName), e);
        }
    }

    public void assertRows(String tableName, ThrowingFunction<ResultSet, Void> consumer) throws Exception {
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM " + tableName);){
            Assertions.assertThat((boolean)rs.next()).isTrue();
            consumer.apply((Object)rs);
        }
        catch (SQLException e) {
            throw new AssertionError("Failed to assert rows", e);
        }
    }

    public void queryContainerTable(String tableName) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("docker");
        commands.add("exec");
        commands.add("-i");
        commands.add("--tty=false");
        commands.add(this.getContainerName());
        switch (this.getType()) {
            case MYSQL: {
                commands.add("mysql");
                commands.add("--user=" + this.getUsername());
                commands.add("--password=" + this.getPassword());
                commands.add("test");
                commands.add("-e");
                commands.add("SELECT * FROM " + tableName);
                break;
            }
            case POSTGRES: {
                commands.add("psql");
                commands.add("-U");
                commands.add(this.getUsername());
                commands.add("-w");
                commands.add("test");
                commands.add("-c");
                commands.add("show time zone; select * from public." + tableName);
                break;
            }
            case ORACLE: {
                commands.add("bash");
                commands.add("-c");
                commands.add("echo \"select * from " + tableName + ";\" | sqlplus debezium/dbz@ORCLPDB1");
                break;
            }
            case SQLSERVER: {
                commands.add("/opt/mssql-tools/bin/sqlcmd");
                commands.add("-U");
                commands.add(this.getUsername());
                commands.add("-P");
                commands.add(this.getPassword());
                commands.add("-d");
                commands.add("testDB");
                commands.add("-Q");
                commands.add("select * from " + tableName + ";");
            }
        }
        this.queryContainer("Source", commands);
    }

    @SafeVarargs
    private <T> boolean isAnyValueNull(T ... values) {
        return Arrays.stream(values).anyMatch(Objects::isNull);
    }

    private static class SinkConnectionInitializer
    implements JdbcConnectionProvider.ConnectionInitializer {
        private final SinkType type;

        SinkConnectionInitializer(SinkType type) {
            this.type = type;
        }

        @Override
        public void initialize(Connection connection) throws SQLException {
            if (SinkType.SQLSERVER.is(this.type)) {
                try (Statement statement = connection.createStatement();){
                    statement.execute("USE testDB");
                }
            }
        }
    }
}

