/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

public class ConnectTimeType
extends AbstractTimeType {
    public static final ConnectTimeType INSTANCE = new ConnectTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Time"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getTimeQueryBinding();
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTime(DateTimeUtils.toZonedDateTimeFromDate((Date)value, this.getDatabaseTimeZone()));
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Date) {
            LocalTime localTime = DateTimeUtils.toLocalTimeFromUtcDate((Date)value);
            LocalDateTime localDateTime = localTime.atDate(LocalDate.now());
            if (this.getDialect().isTimeZoneSet()) {
                query.setParameter(index, (Object)localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()));
            } else {
                query.setParameter(index, (Object)localDateTime);
            }
        } else {
            this.throwUnexpectedValue(value);
        }
        return 1;
    }
}

