/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.Type;
import io.debezium.connector.jdbc.util.SchemaUtils;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.query.Query;

public abstract class AbstractType
implements Type {
    private DatabaseDialect dialect;

    @Override
    public void configure(JdbcSinkConnectorConfig config, DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getQueryBindingWithValueCast(column, schema, this);
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        switch (schema.type()) {
            case INT8: {
                return Byte.toString((Byte)value);
            }
            case INT16: {
                return Short.toString((Short)value);
            }
            case INT32: {
                return Integer.toString((Integer)value);
            }
            case INT64: {
                return Long.toString((Long)value);
            }
            case FLOAT32: {
                return Float.toString(((Float)value).floatValue());
            }
            case FLOAT64: {
                return Double.toString((Double)value);
            }
            case STRING: {
                return "'" + value + "'";
            }
            case BOOLEAN: {
                return dialect.getFormattedBoolean((Boolean)value);
            }
        }
        throw new IllegalArgumentException(String.format("No default value resolution for schema type %s with name %s and type %s", schema.type(), schema.name(), this.getClass().getName()));
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        query.setParameter(index, value);
        return 1;
    }

    protected DatabaseDialect getDialect() {
        return this.dialect;
    }

    protected Optional<String> getSourceColumnType(Schema schema) {
        return SchemaUtils.getSourceColumnType(schema);
    }

    protected Optional<String> getSourceColumnSize(Schema schema) {
        return SchemaUtils.getSourceColumnSize(schema);
    }

    protected Optional<String> getSourceColumnPrecision(Schema schema) {
        return SchemaUtils.getSourceColumnPrecision(schema);
    }

    protected Optional<String> getSchemaParameter(Schema schema, String parameterName) {
        if (!Objects.isNull(schema.parameters())) {
            return Optional.ofNullable((String)schema.parameters().get(parameterName));
        }
        return Optional.empty();
    }

    protected void throwUnexpectedValue(Object value) throws ConnectException {
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value.toString(), value.getClass().getName()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

