/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import java.util.ServiceLoader;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDialectResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseDialectResolver.class);

    public static DatabaseDialect resolve(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        SessionFactoryImplementor implementor = (SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class);
        Dialect dialect = implementor.getJdbcServices().getDialect();
        ServiceLoader<DatabaseDialectProvider> providers = ServiceLoader.load(DatabaseDialectProvider.class);
        for (DatabaseDialectProvider provider : providers) {
            if (!provider.supports(dialect)) continue;
            LOGGER.info("Using dialect {}", (Object)provider.name().getName());
            return provider.instantiate(config, sessionFactory);
        }
        LOGGER.info("Using dialect {}", (Object)GeneralDatabaseDialect.class.getName());
        return new GeneralDatabaseDialect(config, sessionFactory);
    }
}

