/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.JdbcChangeEventSink;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.Module;
import io.debezium.pipeline.sink.spi.ChangeEventSink;
import io.debezium.util.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.runtime.InternalSinkRecord;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkConnectorTask
extends SinkTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSinkConnectorTask.class);
    public static final String SCHEMA_CHANGE_VALUE = "SchemaChangeValue";
    public static final String DETECT_SCHEMA_CHANGE_RECORD_MSG = "Schema change records are not supported by JDBC connector. Adjust `topics` or `topics.regex` to exclude schema change topic.";
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    private final ReentrantLock stateLock = new ReentrantLock();
    private ChangeEventSink changeEventSink;
    private final Map<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
    private Throwable previousPutException;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.stateLock.lock();
        try {
            if (!this.state.compareAndSet(State.STOPPED, State.RUNNING)) {
                LOGGER.info("Connector has already been started");
                return;
            }
            this.previousPutException = null;
            JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(props);
            config.validate();
            this.changeEventSink = new JdbcChangeEventSink(config);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void put(Collection<SinkRecord> records) {
        if (this.previousPutException != null) {
            throw new ConnectException("JDBC sink connector failure", this.previousPutException);
        }
        LOGGER.debug("Received {} changes.", (Object)records.size());
        Iterator<SinkRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            SinkRecord record = iterator.next();
            LOGGER.trace("Received {}", (Object)record);
            try {
                this.validate(record);
                this.changeEventSink.execute(record);
                this.markProcessed(record);
            }
            catch (Throwable throwable) {
                this.markNotProcessed(record);
                LOGGER.error("Failed to process record: {}", (Object)throwable.getMessage(), (Object)throwable);
                this.previousPutException = throwable;
                this.markNotProcessed(iterator);
            }
        }
    }

    private void validate(SinkRecord record) {
        if (JdbcSinkConnectorTask.isSchemaChange(record)) {
            LOGGER.error(DETECT_SCHEMA_CHANGE_RECORD_MSG);
            throw new DataException(DETECT_SCHEMA_CHANGE_RECORD_MSG);
        }
    }

    private static boolean isSchemaChange(SinkRecord record) {
        return record.valueSchema() != null && !Strings.isNullOrEmpty((String)record.valueSchema().name()) && record.valueSchema().name().contains(SCHEMA_CHANGE_VALUE);
    }

    public Map<TopicPartition, OffsetAndMetadata> preCommit(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        LOGGER.debug("Flushing offsets: {}", this.offsets);
        this.flush(this.offsets);
        return this.offsets;
    }

    public void stop() {
        this.stateLock.lock();
        try {
            if (this.previousPutException != null) {
                throw new ConnectException("JDBC sink connector failure", this.previousPutException);
            }
            if (this.changeEventSink != null) {
                try {
                    this.changeEventSink.close();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to gracefully close resources.", (Throwable)e);
                }
            }
        }
        finally {
            if (this.previousPutException != null) {
                this.previousPutException = null;
            }
            if (this.changeEventSink != null) {
                this.changeEventSink = null;
            }
            this.stateLock.unlock();
        }
    }

    private void markProcessed(SinkRecord record) {
        String topicName = this.getOriginalTopicName(record);
        if (Strings.isNullOrBlank((String)topicName)) {
            return;
        }
        LOGGER.trace("Marking processed record for topic {}", (Object)topicName);
        TopicPartition topicPartition = new TopicPartition(topicName, record.kafkaPartition().intValue());
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(record.kafkaOffset() + 1L);
        OffsetAndMetadata existing = this.offsets.put(topicPartition, offsetAndMetadata);
        if (existing == null) {
            LOGGER.trace("Advanced topic {} to offset {}.", (Object)topicName, (Object)record.kafkaOffset());
        } else {
            LOGGER.trace("Updated topic {} from offset {} to {}.", new Object[]{topicName, existing.offset(), record.kafkaOffset()});
        }
    }

    private void markNotProcessed(Iterator<SinkRecord> records) {
        while (records.hasNext()) {
            this.markNotProcessed(records.next());
        }
        this.context.requestCommit();
    }

    private void markNotProcessed(SinkRecord record) {
        TopicPartition topicPartition = new TopicPartition(record.topic(), record.kafkaPartition().intValue());
        if (!this.offsets.containsKey(topicPartition)) {
            LOGGER.debug("Rewinding topic {} offset to {}.", (Object)record.topic(), (Object)record.kafkaOffset());
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(record.kafkaOffset());
            this.offsets.put(topicPartition, offsetAndMetadata);
        }
    }

    private String getOriginalTopicName(SinkRecord record) {
        if (record instanceof InternalSinkRecord) {
            return ((InternalSinkRecord)record).originalRecord().topic();
        }
        return null;
    }

    private static enum State {
        RUNNING,
        STOPPED;

    }
}

