/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.mysql;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkInsertModeTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.MySqlSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.ValueType;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-mysql")})
@ExtendWith(value={MySqlSinkDatabaseContextProvider.class})
public class JdbcSinkInsertModeIT
extends AbstractJdbcSinkInsertModeTest {
    public JdbcSinkInsertModeIT(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6637"})
    public void testInsertModeInsertWithPrimaryKeyModeComplexRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        Schema geometrySchema = JdbcSinkInsertModeIT.buildGeoTypeSchema("Geometry");
        Struct geometryValue = new Struct(geometrySchema).put("wkb", (Object)Base64.getDecoder().decode("AQMAAAABAAAABQAAAAAAAAAAAAAAAAAAAAAAFEAAAAAAAAAAQAAAAAAAABRAAAAAAAAAAEAAAAAAAAAcQAAAAAAAAAAAAAAAAAAAHEAAAAAAAAAAAAAAAAAAABRA".getBytes()));
        Schema pointSchema = JdbcSinkInsertModeIT.buildGeoTypeSchema("Point");
        Struct pointValue = new Struct(pointSchema).put("x", (Object)1.0).put("y", (Object)1.0).put("wkb", (Object)Base64.getDecoder().decode("AQEAAAAAAAAAAADwPwAAAAAAAPA/".getBytes())).put("srid", (Object)3187);
        SinkRecord createGeometryRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, List.of("geometry", "point", "g"), List.of(geometrySchema, pointSchema, geometrySchema), Arrays.asList(geometryValue, pointValue, null));
        this.consume(createGeometryRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createGeometryRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(4);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "geometry", ValueType.BYTES, new byte[][]{DatatypeConverter.parseHexBinary((String)"0000000001030000000100000005000000000000000000000000000000000014400000000000000040000000000000144000000000000000400000000000001C4000000000000000000000000000001C4000000000000000000000000000001440")});
        this.getSink().assertColumnType(tableAssert, "point", ValueType.BYTES, new byte[][]{DatatypeConverter.parseHexBinary((String)"730C00000101000000000000000000F03F000000000000F03F")});
        this.getSink().assertColumnHasNullValue(tableAssert, "g");
    }

    private static Schema buildGeoTypeSchema(String type) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("io.debezium.data.geometry." + type).field("wkb", Schema.BYTES_SCHEMA).field("srid", Schema.OPTIONAL_INT32_SCHEMA).optional();
        if ("Point".equals(type)) {
            schemaBuilder.field("x", Schema.FLOAT64_SCHEMA).field("y", Schema.FLOAT64_SCHEMA);
        }
        return schemaBuilder.build();
    }
}

