/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.junit.jupiter.SinkType;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.util.Strings;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.ValueType;
import org.fest.assertions.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public abstract class AbstractJdbcSinkSchemaEvolutionTest
extends AbstractJdbcSinkTest {
    public AbstractJdbcSinkSchemaEvolutionTest(Sink sink) {
        super(sink);
    }

    @Override
    protected Map<String, String> getDefaultSinkConfig() {
        Map<String, String> config = super.getDefaultSinkConfig();
        String databaseSchemaName = this.getDatabaseSchemaName();
        if (!Strings.isNullOrBlank((String)databaseSchemaName)) {
            config.put("table.name.format", databaseSchemaName + ".${topic}");
        }
        return config;
    }

    protected String getDatabaseSchemaName() {
        return null;
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testCreateShouldFailIfSchemaEvolutionIsDisabled(SinkRecordFactory factory) {
        this.startSinkConnector(this.getDefaultSinkConfig());
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        try {
            this.consume(factory.createRecordNoKey(topicName));
            this.stopSinkConnector();
        }
        catch (Throwable t) {
            Assertions.assertThat((String)t.getCause().getCause().getMessage()).startsWith("Could not find table: ");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testUpdateShouldFailOnUnknownTableIfSchemaEvolutionIsDisabled(SinkRecordFactory factory) {
        this.startSinkConnector(this.getDefaultSinkConfig());
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        try {
            this.consume(factory.updateRecord(topicName));
            this.stopSinkConnector();
        }
        catch (Throwable t) {
            Assertions.assertThat((String)t.getCause().getCause().getMessage()).startsWith("Could not find table: ");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testDeleteShouldFailOnUnknownTableIfSchemaEvolutionIsDisabled(SinkRecordFactory factory) {
        this.startSinkConnector(this.getDefaultSinkConfig());
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        try {
            this.consume(factory.deleteRecord(topicName));
            this.stopSinkConnector();
        }
        catch (Throwable t) {
            Assertions.assertThat((String)t.getCause().getCause().getMessage()).startsWith("Could not find table: ");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testTableCreatedOnCreateRecordWithDefaultInsertMode(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(1)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testTableCreatedOnUpdateRecordWithDefaultInsertMode(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord updateRecord = factory.updateRecord(topicName);
        this.consume(updateRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(updateRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(1)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "Jane Doe");
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testTableCreatedOnDeleteRecordWithDefaultInsertMode(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord deleteRecord = factory.deleteRecord(topicName);
        this.consume(deleteRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(deleteRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(0)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testTableCreatedThenAlteredWithNewColumn(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        SinkRecord updateRecord = factory.updateBuilder().name("prefix").topic(topicName).keySchema(factory.basicKeySchema()).recordSchema((Schema)SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).field("age", Schema.OPTIONAL_INT32_SCHEMA).field("weight", Schema.OPTIONAL_INT32_SCHEMA)).sourceSchema(factory.basicSourceSchema()).key("id", (byte)1).before("id", (byte)1).before("name", "John Doe").after("id", (byte)1).after("name", "John Doe").after("age", 25).after("weight", 150).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
        this.consume(updateRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(2)).hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$", null);
        this.getSink().assertColumnType(tableAssert, "age", ValueType.NUMBER, null, 25);
        this.getSink().assertColumnType(tableAssert, "weight", ValueType.NUMBER, null, 150);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testTableCreatedThenNotAlteredWithRemovedColumn(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        SinkRecord updateRecord = factory.updateBuilder().name("prefix").topic(topicName).keySchema(factory.basicKeySchema()).recordSchema((Schema)SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA)).sourceSchema(factory.basicSourceSchema()).key("id", (byte)1).before("id", (byte)1).after("id", (byte)1).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
        this.consume(updateRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(2)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe", null);
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$", null);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testNonKeyColumnTypeResolutionFromKafkaSchemaType(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String text = "Hello World";
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createBuilder().name("prefix").topic(topicName).keySchema(factory.basicKeySchema()).recordSchema(factory.allKafkaSchemaTypesSchema()).sourceSchema(factory.basicSourceSchema()).key("id", (byte)1).after("id", (byte)1).after("col_int8", (byte)10).after("col_int8_optional", (byte)10).after("col_int16", (short)15).after("col_int16_optional", (short)15).after("col_int32", 1024).after("col_int32_optional", 1024).after("col_int64", 1024L).after("col_int64_optional", 1024L).after("col_float32", Float.valueOf(3.14f)).after("col_float32_optional", Float.valueOf(3.14f)).after("col_float64", 3.14).after("col_float64_optional", 3.14).after("col_bool", true).after("col_bool_optional", true).after("col_string", "Hello World").after("col_string_optional", "Hello World").after("col_bytes", "Hello World".getBytes(StandardCharsets.UTF_8)).after("col_bytes_optional", "Hello World".getBytes(StandardCharsets.UTF_8)).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(1)).hasNumberOfColumns(19);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "col_int8", ValueType.NUMBER, (byte)10);
        this.getSink().assertColumnType(tableAssert, "col_int8_optional", ValueType.NUMBER, (byte)10);
        this.getSink().assertColumnType(tableAssert, "col_int16", ValueType.NUMBER, (short)15);
        this.getSink().assertColumnType(tableAssert, "col_int16_optional", ValueType.NUMBER, (short)15);
        this.getSink().assertColumnType(tableAssert, "col_int32", ValueType.NUMBER, 1024);
        this.getSink().assertColumnType(tableAssert, "col_int32_optional", ValueType.NUMBER, 1024);
        this.getSink().assertColumnType(tableAssert, "col_int64", ValueType.NUMBER, 1024L);
        this.getSink().assertColumnType(tableAssert, "col_int64_optional", ValueType.NUMBER, 1024L);
        this.getSink().assertColumnType(tableAssert, "col_float32", ValueType.NUMBER, Float.valueOf(3.14f));
        this.getSink().assertColumnType(tableAssert, "col_float32_optional", ValueType.NUMBER, Float.valueOf(3.14f));
        this.getSink().assertColumnType(tableAssert, "col_float64", ValueType.NUMBER, 3.14);
        this.getSink().assertColumnType(tableAssert, "col_float64_optional", ValueType.NUMBER, 3.14);
        this.getSink().assertColumnType(tableAssert, "col_string", ValueType.TEXT, "Hello World");
        this.getSink().assertColumnType(tableAssert, "col_string_optional", ValueType.TEXT, "Hello World");
        this.getSink().assertColumnType(tableAssert, "col_bytes", ValueType.BYTES, new byte[][]{"Hello World".getBytes(StandardCharsets.UTF_8)});
        this.getSink().assertColumnType(tableAssert, "col_bytes_optional", ValueType.BYTES, new byte[][]{"Hello World".getBytes(StandardCharsets.UTF_8)});
        if (this.getSink().getType().is(SinkType.ORACLE)) {
            this.getSink().assertColumnType(tableAssert, "col_bool", ValueType.NUMBER, 1);
            this.getSink().assertColumnType(tableAssert, "col_bool_optional", ValueType.NUMBER, 1);
        } else {
            this.getSink().assertColumnType(tableAssert, "col_bool", ValueType.BOOLEAN, true);
            this.getSink().assertColumnType(tableAssert, "col_bool_optional", ValueType.BOOLEAN, true);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testNonKeyColumnTypeResolutionFromKafkaSchemaTypeWithOptionalsWithDefaultValues(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String text = "Hello World";
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createBuilder().name("prefix").topic(topicName).keySchema(factory.basicKeySchema()).recordSchema(factory.allKafkaSchemaTypesSchemaWithOptionalDefaultValues()).sourceSchema(factory.basicSourceSchema()).key("id", (byte)1).after("id", (byte)1).after("col_int8", (byte)10).after("col_int16", (short)15).after("col_int32", 1024).after("col_int64", 1024L).after("col_float32", Float.valueOf(3.14f)).after("col_float64", 3.14).after("col_bool", true).after("col_string", "Hello World").after("col_bytes", "Hello World".getBytes(StandardCharsets.UTF_8)).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(1)).hasNumberOfColumns(19);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "col_int8", ValueType.NUMBER, (byte)10);
        this.getSink().assertColumnType(tableAssert, "col_int8_optional", ValueType.NUMBER, (byte)10);
        this.getSink().assertColumnType(tableAssert, "col_int16", ValueType.NUMBER, (short)15);
        this.getSink().assertColumnType(tableAssert, "col_int16_optional", ValueType.NUMBER, (short)15);
        this.getSink().assertColumnType(tableAssert, "col_int32", ValueType.NUMBER, 1024);
        this.getSink().assertColumnType(tableAssert, "col_int32_optional", ValueType.NUMBER, 1024);
        this.getSink().assertColumnType(tableAssert, "col_int64", ValueType.NUMBER, 1024L);
        this.getSink().assertColumnType(tableAssert, "col_int64_optional", ValueType.NUMBER, 1024L);
        this.getSink().assertColumnType(tableAssert, "col_float32", ValueType.NUMBER, Float.valueOf(3.14f));
        this.getSink().assertColumnType(tableAssert, "col_float32_optional", ValueType.NUMBER, Float.valueOf(3.14f));
        this.getSink().assertColumnType(tableAssert, "col_float64", ValueType.NUMBER, 3.14);
        this.getSink().assertColumnType(tableAssert, "col_float64_optional", ValueType.NUMBER, 3.14);
        this.getSink().assertColumnType(tableAssert, "col_string", ValueType.TEXT, "Hello World");
        this.getSink().assertColumnType(tableAssert, "col_string_optional", ValueType.TEXT, "Hello World");
        this.getSink().assertColumnType(tableAssert, "col_bytes", ValueType.BYTES, new byte[][]{"Hello World".getBytes(StandardCharsets.UTF_8)});
        this.getSink().assertColumnType(tableAssert, "col_bytes_optional", ValueType.BYTES, new byte[][]{"Hello World".getBytes(StandardCharsets.UTF_8)});
        if (this.getSink().getType().is(SinkType.ORACLE)) {
            this.getSink().assertColumnType(tableAssert, "col_bool", ValueType.NUMBER, 1);
            this.getSink().assertColumnType(tableAssert, "col_bool_optional", ValueType.NUMBER, true);
        } else {
            this.getSink().assertColumnType(tableAssert, "col_bool", ValueType.BOOLEAN, true);
            this.getSink().assertColumnType(tableAssert, "col_bool_optional", ValueType.BOOLEAN, true);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void shouldCreateTableWithDefaultValues(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        Schema recordSchemaCreate = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("col_int8", SchemaBuilder.int8().defaultValue((Object)2).build()).field("col_int8_optional", SchemaBuilder.int8().optional().defaultValue((Object)2).build()).field("col_int16", SchemaBuilder.int16().defaultValue((Object)2).build()).field("col_int16_optional", SchemaBuilder.int16().optional().defaultValue((Object)2).build()).field("col_int32", SchemaBuilder.int32().defaultValue((Object)2048).build()).field("col_int32_optional", SchemaBuilder.int32().optional().defaultValue((Object)2048).build()).field("col_int64", SchemaBuilder.int64().defaultValue((Object)2048L).build()).field("col_int64_optional", SchemaBuilder.int64().optional().defaultValue((Object)2048L).build()).field("col_float32", SchemaBuilder.float32().defaultValue((Object)Float.valueOf(2.34f)).build()).field("col_float32_optional", SchemaBuilder.float32().optional().defaultValue((Object)Float.valueOf(2.34f)).build()).field("col_float64", SchemaBuilder.float64().defaultValue((Object)1.23).build()).field("col_float64_optional", SchemaBuilder.float64().optional().defaultValue((Object)1.23).build()).field("col_bool", SchemaBuilder.bool().defaultValue((Object)true).build()).field("col_bool_optional", SchemaBuilder.bool().optional().defaultValue((Object)true).build()).field("col_string", SchemaBuilder.string().defaultValue((Object)"test").build()).field("col_string_optional", SchemaBuilder.string().optional().defaultValue((Object)"test").build()).field("col_bytes", SchemaBuilder.bytes().defaultValue((Object)"test".getBytes()).build()).field("col_bytes_optional", SchemaBuilder.bytes().optional().defaultValue((Object)"test".getBytes()).build()).build();
        String text = "Hello World";
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createBuilder().name("prefix").topic(topicName).keySchema(factory.basicKeySchema()).recordSchema(recordSchemaCreate).sourceSchema(factory.basicSourceSchema()).key("id", (byte)1).after("id", (byte)1).after("col_int8_optional", (byte)2).after("col_int16_optional", (short)2).after("col_int32_optional", 2048).after("col_int64_optional", 2048L).after("col_float32_optional", Float.valueOf(2.34f)).after("col_float64_optional", 1.23).after("col_bool_optional", true).after("col_string_optional", "Hello World").after("col_bytes_optional", "Hello World".getBytes(StandardCharsets.UTF_8)).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.hasNumberOfRows(1)).hasNumberOfColumns(19);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "col_int8", ValueType.NUMBER, (byte)2);
        this.getSink().assertColumnType(tableAssert, "col_int8_optional", ValueType.NUMBER, (byte)2);
        this.getSink().assertColumnType(tableAssert, "col_int16", ValueType.NUMBER, (short)2);
        this.getSink().assertColumnType(tableAssert, "col_int16_optional", ValueType.NUMBER, (short)2);
        this.getSink().assertColumnType(tableAssert, "col_int32", ValueType.NUMBER, 2048);
        this.getSink().assertColumnType(tableAssert, "col_int32_optional", ValueType.NUMBER, 2048);
        this.getSink().assertColumnType(tableAssert, "col_int64", ValueType.NUMBER, 2048L);
        this.getSink().assertColumnType(tableAssert, "col_int64_optional", ValueType.NUMBER, 2048L);
        this.getSink().assertColumnType(tableAssert, "col_float32", ValueType.NUMBER, Float.valueOf(2.34f));
        this.getSink().assertColumnType(tableAssert, "col_float32_optional", ValueType.NUMBER, Float.valueOf(2.34f));
        this.getSink().assertColumnType(tableAssert, "col_float64", ValueType.NUMBER, 1.23);
        this.getSink().assertColumnType(tableAssert, "col_float64_optional", ValueType.NUMBER, 1.23);
        this.getSink().assertColumnType(tableAssert, "col_string", ValueType.TEXT, "test");
        this.getSink().assertColumnType(tableAssert, "col_string_optional", ValueType.TEXT, "Hello World");
        this.getSink().assertColumnType(tableAssert, "col_bytes", ValueType.BYTES, new byte[][]{"test".getBytes(StandardCharsets.UTF_8)});
        this.getSink().assertColumnType(tableAssert, "col_bytes_optional", ValueType.BYTES, new byte[][]{"Hello World".getBytes(StandardCharsets.UTF_8)});
        if (this.getSink().getType().is(SinkType.ORACLE)) {
            this.getSink().assertColumnType(tableAssert, "col_bool", ValueType.NUMBER, 1);
            this.getSink().assertColumnType(tableAssert, "col_bool_optional", ValueType.NUMBER, 1);
        } else {
            this.getSink().assertColumnType(tableAssert, "col_bool", ValueType.BOOLEAN, true);
            this.getSink().assertColumnType(tableAssert, "col_bool_optional", ValueType.BOOLEAN, true);
        }
    }
}

