/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.util;

import io.debezium.time.Conversions;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static Instant toInstantFromNanos(long epochNanos) {
        long epochSeconds = TimeUnit.NANOSECONDS.toSeconds(epochNanos);
        long adjustment = TimeUnit.NANOSECONDS.toNanos(epochNanos % TimeUnit.SECONDS.toNanos(1L));
        return Instant.ofEpochSecond(epochSeconds, adjustment);
    }

    public static ZonedDateTime toZonedDateTimeFromDate(Date date, TimeZone timeZone) {
        return DateTimeUtils.toZonedDateTimeFromDate(date, timeZone.toZoneId());
    }

    public static ZonedDateTime toZonedDateTimeFromDate(Date date, ZoneId zoneId) {
        return date.toInstant().atZone(zoneId);
    }

    public static ZonedDateTime toZonedDateTimeFromInstantEpochMicros(long epochMicros) {
        return Conversions.toInstantFromMicros((long)epochMicros).atZone(ZoneOffset.UTC);
    }

    public static ZonedDateTime toZonedDateTimeFromInstantEpochNanos(long epochNanos) {
        return ZonedDateTime.ofInstant(DateTimeUtils.toInstantFromNanos(epochNanos), ZoneOffset.UTC);
    }

    public static LocalDate toLocalDateOfEpochDays(long epochDays) {
        return LocalDate.ofEpochDay(epochDays);
    }

    public static LocalDate toLocalDateFromDate(Date date) {
        return DateTimeUtils.toLocalDateFromInstantEpochMillis(date.getTime());
    }

    public static LocalDate toLocalDateFromInstantEpochMillis(long epochMillis) {
        return LocalDate.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC);
    }

    public static LocalTime toLocalTimeFromDurationMilliseconds(long durationMillis) {
        return LocalTime.ofNanoOfDay(Duration.of(durationMillis, ChronoUnit.MILLIS).toNanos());
    }

    public static LocalTime toLocalTimeFromDurationMicroseconds(long durationMicros) {
        return LocalTime.ofNanoOfDay(Duration.of(durationMicros, ChronoUnit.MICROS).toNanos());
    }

    public static LocalTime toLocalTimeFromDurationNanoseconds(long durationNanos) {
        return LocalTime.ofNanoOfDay(Duration.of(durationNanos, ChronoUnit.NANOS).toNanos());
    }

    public static LocalTime toLocalTimeFromUtcDate(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC).toLocalTime();
    }

    public static LocalDateTime toLocalDateTimeFromDate(Date date) {
        return DateTimeUtils.toLocalDateTimeFromInstantEpochMillis(date.getTime());
    }

    public static LocalDateTime toLocalDateTimeFromInstantEpochMillis(long epochMillis) {
        return LocalDateTime.ofInstant(Conversions.toInstantFromMillis((long)epochMillis), ZoneOffset.UTC);
    }

    public static LocalDateTime toLocalDateTimeFromInstantEpochMicros(long epochMicros) {
        return LocalDateTime.ofInstant(Conversions.toInstantFromMicros((long)epochMicros), ZoneOffset.UTC);
    }

    public static LocalDateTime toLocalDateTimeFromInstantEpochNanos(long epochNanos) {
        return LocalDateTime.ofInstant(DateTimeUtils.toInstantFromNanos(epochNanos), ZoneOffset.UTC);
    }

    public static Timestamp toTimestampFromMillis(long epochMilliseconds) {
        Instant instant = Conversions.toInstantFromMillis((long)epochMilliseconds);
        Timestamp ts = new Timestamp(instant.toEpochMilli());
        ts.setNanos(instant.getNano());
        return ts;
    }
}

