/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.data.VariableScaleDecimal;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.hibernate.query.Query;

public class VariableScaleDecimalType
extends AbstractType {
    public static final VariableScaleDecimalType INSTANCE = new VariableScaleDecimalType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.VariableScaleDecimal"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return dialect.getTypeName(8);
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Struct) {
            Optional bigDecimalValue = VariableScaleDecimal.toLogical((Struct)((Struct)value)).getDecimalValue();
            query.setParameter(index, bigDecimalValue.orElseThrow());
        } else {
            this.throwUnexpectedValue(value);
        }
        return 1;
    }
}

