/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.List;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultInitializer;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T>,
EmbeddableResult<T> {
    private final String resultVariable;
    private final boolean containsAnyNonScalars;
    private final NavigablePath initializerNavigablePath;

    public EmbeddableResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, String resultVariable, DomainResultCreationState creationState) {
        super(modelPart.getEmbeddableTypeDescriptor(), navigablePath);
        this.resultVariable = resultVariable;
        this.initializerNavigablePath = navigablePath.append("{embeddable_result}");
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        fromClauseAccess.resolveTableGroup(navigablePath, np -> {
            EmbeddableValuedModelPart embeddedValueMapping = modelPart.getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
            TableGroup tableGroup = fromClauseAccess.findTableGroup(navigablePath.getParent());
            TableGroupJoin tableGroupJoin = embeddedValueMapping.createTableGroupJoin(navigablePath, tableGroup, resultVariable, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            tableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        this.afterInitialize(this, creationState);
        this.containsAnyNonScalars = EmbeddableResultImpl.determineIfContainedAnyScalars(this.getFetches());
    }

    private static boolean determineIfContainedAnyScalars(List<Fetch> fetches) {
        for (int i = 0; i < fetches.size(); ++i) {
            if (!fetches.get(i).containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return this.containsAnyNonScalars;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getReferencedMappingType().getJavaType();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EmbeddableInitializer initializer = (EmbeddableInitializer)creationState.resolveInitializer(this.initializerNavigablePath, this.getReferencedModePart(), () -> new EmbeddableResultInitializer(this, parentAccess, creationState));
        return new EmbeddableAssembler(initializer);
    }
}

