/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public class AnnotatedJoinColumn
extends AnnotatedColumn {
    private String referencedColumn;
    private String mappedBy;
    private String mappedByPropertyName;
    private String mappedByTableName;
    private String mappedByEntityName;
    private String mappedByJpaEntityName;
    private boolean JPA2ElementCollection;
    private String manyToManyOwnerSideEntityName;
    public static final int NO_REFERENCE = 0;
    public static final int PK_REFERENCE = 1;
    public static final int NON_PK_REFERENCE = 2;

    public void setJPA2ElementCollection(boolean JPA2ElementCollection) {
        this.JPA2ElementCollection = JPA2ElementCollection;
    }

    public String getManyToManyOwnerSideEntityName() {
        return this.manyToManyOwnerSideEntityName;
    }

    public void setManyToManyOwnerSideEntityName(String manyToManyOwnerSideEntityName) {
        this.manyToManyOwnerSideEntityName = manyToManyOwnerSideEntityName;
    }

    public void setReferencedColumn(String referencedColumn) {
        this.referencedColumn = referencedColumn;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    private AnnotatedJoinColumn() {
        this.setMappedBy("");
    }

    private AnnotatedJoinColumn(String sqlType, String name, String comment, boolean nullable, boolean unique, boolean insertable, boolean updatable, String referencedColumn, String secondaryTable, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, String mappedBy, boolean isImplicit, MetadataBuildingContext buildingContext) {
        this.setImplicit(isImplicit);
        this.setSqlType(sqlType);
        this.setLogicalColumnName(name);
        this.setComment(comment);
        this.setNullable(nullable);
        this.setUnique(unique);
        this.setInsertable(insertable);
        this.setUpdatable(updatable);
        this.setExplicitTableName(secondaryTable);
        this.setPropertyHolder(propertyHolder);
        this.setJoins(joins);
        this.setBuildingContext(buildingContext);
        this.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        this.bind();
        this.referencedColumn = referencedColumn;
        this.mappedBy = mappedBy;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public static AnnotatedJoinColumn[] buildJoinColumnsOrFormulas(JoinColumnOrFormula[] anns, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        AnnotatedJoinColumn[] joinColumns = new AnnotatedJoinColumn[anns.length];
        for (int i = 0; i < anns.length; ++i) {
            JoinColumnOrFormula join = anns[i];
            JoinFormula formula = join.formula();
            joinColumns[i] = formula.value() != null && !formula.value().isEmpty() ? AnnotatedJoinColumn.buildJoinFormula(formula, mappedBy, joins, propertyHolder, propertyName, buildingContext) : AnnotatedJoinColumn.buildJoinColumns(new JoinColumn[]{join.column()}, null, mappedBy, joins, propertyHolder, propertyName, buildingContext)[0];
        }
        return joinColumns;
    }

    public static AnnotatedJoinColumn buildJoinFormula(JoinFormula ann, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        AnnotatedJoinColumn formulaColumn = new AnnotatedJoinColumn();
        formulaColumn.setFormula(ann.value());
        formulaColumn.setReferencedColumn(ann.referencedColumnName());
        formulaColumn.setBuildingContext(buildingContext);
        formulaColumn.setPropertyHolder(propertyHolder);
        formulaColumn.setJoins(joins);
        formulaColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        formulaColumn.bind();
        return formulaColumn;
    }

    public static AnnotatedJoinColumn[] buildJoinColumns(JoinColumn[] anns, Comment comment, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        return AnnotatedJoinColumn.buildJoinColumnsWithDefaultColumnSuffix(anns, comment, mappedBy, joins, propertyHolder, propertyName, "", buildingContext);
    }

    public static AnnotatedJoinColumn[] buildJoinColumnsWithDefaultColumnSuffix(JoinColumn[] anns, Comment comment, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, String suffixForDefaultColumnName, MetadataBuildingContext buildingContext) {
        JoinColumn[] actualColumns = propertyHolder.getOverriddenJoinColumn(StringHelper.qualify(propertyHolder.getPath(), propertyName));
        if (actualColumns == null) {
            actualColumns = anns;
        }
        if (actualColumns == null || actualColumns.length == 0) {
            return new AnnotatedJoinColumn[]{AnnotatedJoinColumn.buildJoinColumn(null, comment, mappedBy, joins, propertyHolder, propertyName, suffixForDefaultColumnName, buildingContext)};
        }
        int size = actualColumns.length;
        AnnotatedJoinColumn[] result = new AnnotatedJoinColumn[size];
        for (int index = 0; index < size; ++index) {
            result[index] = AnnotatedJoinColumn.buildJoinColumn(actualColumns[index], comment, mappedBy, joins, propertyHolder, propertyName, suffixForDefaultColumnName, buildingContext);
        }
        return result;
    }

    private static AnnotatedJoinColumn buildJoinColumn(JoinColumn ann, Comment comment, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, String suffixForDefaultColumnName, MetadataBuildingContext buildingContext) {
        if (ann != null) {
            if (!BinderHelper.isEmptyOrNullAnnotationValue(mappedBy)) {
                throw new AnnotationException("Association '" + BinderHelper.getRelativePath(propertyHolder, propertyName) + "' is 'mappedBy' a different entity and may not explicitly specify the '@JoinColumn'");
            }
            AnnotatedJoinColumn joinColumn = new AnnotatedJoinColumn();
            joinColumn.setComment(comment != null ? comment.value() : null);
            joinColumn.setBuildingContext(buildingContext);
            joinColumn.setJoinAnnotation(ann, null);
            if (StringHelper.isEmpty(joinColumn.getLogicalColumnName()) && !StringHelper.isEmpty(suffixForDefaultColumnName)) {
                joinColumn.setLogicalColumnName(propertyName + suffixForDefaultColumnName);
            }
            joinColumn.setJoins(joins);
            joinColumn.setPropertyHolder(propertyHolder);
            joinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            joinColumn.setImplicit(false);
            joinColumn.bind();
            return joinColumn;
        }
        AnnotatedJoinColumn joinColumn = new AnnotatedJoinColumn();
        joinColumn.setMappedBy(mappedBy);
        joinColumn.setJoins(joins);
        joinColumn.setPropertyHolder(propertyHolder);
        joinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        if (!StringHelper.isEmpty(suffixForDefaultColumnName)) {
            joinColumn.setLogicalColumnName(propertyName + suffixForDefaultColumnName);
            joinColumn.setImplicit(false);
        } else {
            joinColumn.setImplicit(true);
        }
        joinColumn.setBuildingContext(buildingContext);
        joinColumn.bind();
        return joinColumn;
    }

    public void setJoinAnnotation(JoinColumn annJoin, String defaultName) {
        if (annJoin == null) {
            this.setImplicit(true);
        } else {
            this.setImplicit(false);
            if (!BinderHelper.isEmptyAnnotationValue(annJoin.columnDefinition())) {
                this.setSqlType(this.getBuildingContext().getObjectNameNormalizer().applyGlobalQuoting(annJoin.columnDefinition()));
            }
            if (!BinderHelper.isEmptyAnnotationValue(annJoin.name())) {
                this.setLogicalColumnName(annJoin.name());
            }
            this.setNullable(annJoin.nullable());
            this.setUnique(annJoin.unique());
            this.setInsertable(annJoin.insertable());
            this.setUpdatable(annJoin.updatable());
            this.setReferencedColumn(annJoin.referencedColumnName());
            if (BinderHelper.isEmptyAnnotationValue(annJoin.table())) {
                this.setExplicitTableName("");
            } else {
                Identifier logicalIdentifier = this.getBuildingContext().getMetadataCollector().getDatabase().toIdentifier(annJoin.table());
                Identifier physicalIdentifier = this.getBuildingContext().getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalIdentifier, this.getBuildingContext().getMetadataCollector().getDatabase().getJdbcEnvironment());
                this.setExplicitTableName(physicalIdentifier.render(this.getBuildingContext().getMetadataCollector().getDatabase().getDialect()));
            }
        }
    }

    public static AnnotatedJoinColumn buildJoinColumn(PrimaryKeyJoinColumn pkJoinAnn, JoinColumn joinAnn, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, MetadataBuildingContext context) {
        String defaultName = context.getMetadataCollector().getLogicalColumnName(identifier.getTable(), identifier.getColumns().get(0).getQuotedName());
        ObjectNameNormalizer normalizer = context.getObjectNameNormalizer();
        if (pkJoinAnn != null || joinAnn != null) {
            String referencedColumnName;
            String columnDefinition;
            String colName;
            if (pkJoinAnn != null) {
                colName = pkJoinAnn.name();
                columnDefinition = pkJoinAnn.columnDefinition();
                referencedColumnName = pkJoinAnn.referencedColumnName();
            } else {
                colName = joinAnn.name();
                columnDefinition = joinAnn.columnDefinition();
                referencedColumnName = joinAnn.referencedColumnName();
            }
            return new AnnotatedJoinColumn(columnDefinition.isEmpty() ? null : normalizer.toDatabaseIdentifierText(columnDefinition), colName != null && colName.isEmpty() ? normalizer.normalizeIdentifierQuotingAsString(defaultName) : normalizer.normalizeIdentifierQuotingAsString(colName), null, false, false, true, true, referencedColumnName, null, joins, propertyHolder, null, null, false, context);
        }
        return new AnnotatedJoinColumn(null, normalizer.normalizeIdentifierQuotingAsString(defaultName), null, false, false, true, true, null, null, joins, propertyHolder, null, null, true, context);
    }

    public void setPersistentClass(PersistentClass persistentClass, Map<String, Join> joins, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        this.propertyHolder = PropertyHolderBuilder.buildPropertyHolder(persistentClass, joins, this.getBuildingContext(), inheritanceStatePerClass);
    }

    public static void checkIfJoinColumn(Object columns, PropertyHolder holder, PropertyData property) {
        if (!(columns instanceof AnnotatedJoinColumn[])) {
            throw new AnnotationException("Property '" + BinderHelper.getRelativePath(holder, property.getPropertyName()) + "' is an association and may not use '@Column' to specify column mappings (use '@JoinColumn' instead)");
        }
    }

    public void copyReferencedStructureAndCreateDefaultJoinColumns(PersistentClass referencedEntity, SimpleValue referencedValue, SimpleValue value) {
        if (!this.isNameDeferred()) {
            throw new AssertionFailure("Building implicit column but the column is not implicit");
        }
        for (Column synthCol : referencedValue.getColumns()) {
            this.linkValueUsingDefaultColumnNaming(synthCol, referencedEntity, value);
        }
        this.setMappingColumn(null);
    }

    public void linkValueUsingDefaultColumnNaming(Column referencedColumn, PersistentClass referencedEntity, SimpleValue value) {
        String logicalReferencedColumn = this.getBuildingContext().getMetadataCollector().getLogicalColumnName(referencedEntity.getTable(), referencedColumn.getQuotedName());
        String columnName = this.buildDefaultColumnName(referencedEntity, logicalReferencedColumn);
        this.setLogicalColumnName(columnName);
        this.setReferencedColumn(logicalReferencedColumn);
        this.initMappingColumn(columnName, null, referencedColumn.getLength(), referencedColumn.getPrecision(), referencedColumn.getScale(), this.getMappingColumn() != null && this.getMappingColumn().isNullable(), referencedColumn.getSqlType(), this.getMappingColumn() != null && this.getMappingColumn().isUnique(), false);
        this.linkWithValue(value);
    }

    public void addDefaultJoinColumnName(PersistentClass referencedEntity, String logicalReferencedColumn) {
        String columnName = this.buildDefaultColumnName(referencedEntity, logicalReferencedColumn);
        this.getMappingColumn().setName(columnName);
        this.setLogicalColumnName(columnName);
    }

    private String buildDefaultColumnName(final PersistentClass referencedEntity, final String logicalReferencedColumn) {
        Identifier columnIdentifier;
        final InFlightMetadataCollector metadataCollector = this.getBuildingContext().getMetadataCollector();
        final Database database = metadataCollector.getDatabase();
        ImplicitNamingStrategy implicitNamingStrategy = this.getBuildingContext().getBuildingOptions().getImplicitNamingStrategy();
        PhysicalNamingStrategy physicalNamingStrategy = this.getBuildingContext().getBuildingOptions().getPhysicalNamingStrategy();
        boolean mappedBySide = this.mappedByTableName != null || this.mappedByPropertyName != null;
        boolean ownerSide = this.getPropertyName() != null;
        boolean isRefColumnQuoted = StringHelper.isQuoted(logicalReferencedColumn);
        if (mappedBySide) {
            columnIdentifier = implicitNamingStrategy.determineJoinColumnName(new ImplicitJoinColumnNameSource(){
                final AttributePath attributePath;
                final ImplicitJoinColumnNameSource.Nature implicitNamingNature;
                private final EntityNaming entityNaming;
                private final Identifier referencedTableName;
                {
                    this.attributePath = AttributePath.parse(AnnotatedJoinColumn.this.mappedByPropertyName);
                    this.implicitNamingNature = AnnotatedJoinColumn.this.getImplicitNature();
                    this.entityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return referencedEntity.getClassName();
                        }

                        @Override
                        public String getEntityName() {
                            return referencedEntity.getEntityName();
                        }

                        @Override
                        public String getJpaEntityName() {
                            return referencedEntity.getJpaEntityName();
                        }
                    };
                    this.referencedTableName = database.toIdentifier(AnnotatedJoinColumn.this.mappedByTableName);
                }

                @Override
                public ImplicitJoinColumnNameSource.Nature getNature() {
                    return this.implicitNamingNature;
                }

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public AttributePath getAttributePath() {
                    return this.attributePath;
                }

                @Override
                public Identifier getReferencedTableName() {
                    return this.referencedTableName;
                }

                @Override
                public Identifier getReferencedColumnName() {
                    if (logicalReferencedColumn != null) {
                        return database.toIdentifier(logicalReferencedColumn);
                    }
                    if (AnnotatedJoinColumn.this.mappedByEntityName == null || AnnotatedJoinColumn.this.mappedByPropertyName == null) {
                        return null;
                    }
                    Property mappedByProperty = metadataCollector.getEntityBinding(AnnotatedJoinColumn.this.mappedByEntityName).getProperty(AnnotatedJoinColumn.this.mappedByPropertyName);
                    SimpleValue value = (SimpleValue)mappedByProperty.getValue();
                    if (value.getSelectables().isEmpty()) {
                        throw new AnnotationException(String.format(Locale.ENGLISH, "Association '%s' is 'mappedBy' a property '%s' of entity '%s' with no columns", AnnotatedJoinColumn.this.propertyHolder.getPath(), AnnotatedJoinColumn.this.mappedByPropertyName, AnnotatedJoinColumn.this.mappedByEntityName));
                    }
                    Selectable selectable = value.getSelectables().get(0);
                    if (!(selectable instanceof Column)) {
                        throw new AnnotationException(String.format(Locale.ENGLISH, "Association '%s' is 'mappedBy' a property '%s' of entity '%s' which maps to a formula", AnnotatedJoinColumn.this.mappedByPropertyName, AnnotatedJoinColumn.this.propertyHolder.getPath()));
                    }
                    if (value.getSelectables().size() > 1) {
                        throw new AnnotationException(String.format(Locale.ENGLISH, "Association '%s' is 'mappedBy' a property '%s' of entity '%s' with multiple columns", AnnotatedJoinColumn.this.mappedByPropertyName, AnnotatedJoinColumn.this.propertyHolder.getPath()));
                    }
                    return database.toIdentifier(((Column)selectable).getQuotedName());
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return AnnotatedJoinColumn.this.getBuildingContext();
                }
            });
            if (isRefColumnQuoted || StringHelper.isQuoted(this.mappedByTableName)) {
                columnIdentifier = Identifier.quote(columnIdentifier);
            }
        } else if (ownerSide) {
            final String logicalTableName = metadataCollector.getLogicalTableName(referencedEntity.getTable());
            columnIdentifier = implicitNamingStrategy.determineJoinColumnName(new ImplicitJoinColumnNameSource(){
                final ImplicitJoinColumnNameSource.Nature implicitNamingNature;
                private final EntityNaming entityNaming;
                private final AttributePath attributePath;
                private final Identifier referencedTableName;
                private final Identifier referencedColumnName;
                {
                    this.implicitNamingNature = AnnotatedJoinColumn.this.getImplicitNature();
                    this.entityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return referencedEntity.getClassName();
                        }

                        @Override
                        public String getEntityName() {
                            return referencedEntity.getEntityName();
                        }

                        @Override
                        public String getJpaEntityName() {
                            return referencedEntity.getJpaEntityName();
                        }
                    };
                    this.attributePath = AttributePath.parse(AnnotatedJoinColumn.this.getPropertyName());
                    this.referencedTableName = database.toIdentifier(logicalTableName);
                    this.referencedColumnName = database.toIdentifier(logicalReferencedColumn);
                }

                @Override
                public ImplicitJoinColumnNameSource.Nature getNature() {
                    return this.implicitNamingNature;
                }

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public AttributePath getAttributePath() {
                    return this.attributePath;
                }

                @Override
                public Identifier getReferencedTableName() {
                    return this.referencedTableName;
                }

                @Override
                public Identifier getReferencedColumnName() {
                    return this.referencedColumnName;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return AnnotatedJoinColumn.this.getBuildingContext();
                }
            });
            if (columnIdentifier.getText().contains("_collection&&element_")) {
                columnIdentifier = Identifier.toIdentifier(columnIdentifier.getText().replace("_collection&&element_", "_"), columnIdentifier.isQuoted());
            }
            if (isRefColumnQuoted || StringHelper.isQuoted(logicalTableName)) {
                columnIdentifier = Identifier.quote(columnIdentifier);
            }
        } else {
            final Identifier logicalTableName = database.toIdentifier(metadataCollector.getLogicalTableName(referencedEntity.getTable()));
            columnIdentifier = implicitNamingStrategy.determinePrimaryKeyJoinColumnName(new ImplicitPrimaryKeyJoinColumnNameSource(){

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return AnnotatedJoinColumn.this.getBuildingContext();
                }

                @Override
                public Identifier getReferencedTableName() {
                    return logicalTableName;
                }

                @Override
                public Identifier getReferencedPrimaryKeyColumnName() {
                    return database.toIdentifier(logicalReferencedColumn);
                }
            });
            if (!columnIdentifier.isQuoted() && (isRefColumnQuoted || logicalTableName.isQuoted())) {
                columnIdentifier = Identifier.quote(columnIdentifier);
            }
        }
        return physicalNamingStrategy.toPhysicalColumnName(columnIdentifier, database.getJdbcEnvironment()).render(database.getJdbcEnvironment().getDialect());
    }

    private ImplicitJoinColumnNameSource.Nature getImplicitNature() {
        if (this.getPropertyHolder().isEntity()) {
            return ImplicitJoinColumnNameSource.Nature.ENTITY;
        }
        if (this.JPA2ElementCollection) {
            return ImplicitJoinColumnNameSource.Nature.ELEMENT_COLLECTION;
        }
        return ImplicitJoinColumnNameSource.Nature.ENTITY_COLLECTION;
    }

    public void linkValueUsingAColumnCopy(Column column, SimpleValue value) {
        this.initMappingColumn(column.getQuotedName(), null, column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique(), false);
        this.linkWithValue(value);
    }

    @Override
    protected void addColumnBinding(SimpleValue value) {
        if (StringHelper.isEmpty(this.mappedBy)) {
            boolean isLogicalColumnQuoted = StringHelper.isQuoted(this.getLogicalColumnName());
            ObjectNameNormalizer nameNormalizer = this.getBuildingContext().getObjectNameNormalizer();
            String logicalColumnName = nameNormalizer.normalizeIdentifierQuotingAsString(this.getLogicalColumnName());
            String referencedColumn = nameNormalizer.normalizeIdentifierQuotingAsString(this.getReferencedColumn());
            String unquotedLogColName = StringHelper.unquote(logicalColumnName);
            String unquotedRefColumn = StringHelper.unquote(referencedColumn);
            String logicalCollectionColumnName = StringHelper.isNotEmpty(unquotedLogColName) ? unquotedLogColName : this.getPropertyName() + "_" + unquotedRefColumn;
            logicalCollectionColumnName = this.getBuildingContext().getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(logicalCollectionColumnName, isLogicalColumnQuoted).render();
            this.getBuildingContext().getMetadataCollector().addColumnNameBinding(value.getTable(), logicalCollectionColumnName, this.getMappingColumn());
        }
    }

    public static int checkReferencedColumnsType(AnnotatedJoinColumn[] columns, PersistentClass referencedEntity, MetadataBuildingContext context) {
        if (columns.length == 0) {
            return 0;
        }
        AttributeContainer columnOwner = BinderHelper.findColumnOwner(referencedEntity, columns[0].getReferencedColumn(), context);
        if (columnOwner == null) {
            try {
                throw new MappingException("A '@JoinColumn' references a column named '" + columns[0].getReferencedColumn() + "' but the target entity '" + referencedEntity.getEntityName() + "' has no property which maps to this column");
            }
            catch (MappingException e) {
                throw new RecoverableException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        Table table = columnOwner instanceof PersistentClass ? ((PersistentClass)columnOwner).getTable() : ((Join)columnOwner).getTable();
        List<Selectable> keyColumns = referencedEntity.getKey().getSelectables();
        boolean explicitColumnReference = false;
        for (AnnotatedJoinColumn column : columns) {
            String logicalReferencedColumnName = column.getReferencedColumn();
            if (!StringHelper.isNotEmpty(logicalReferencedColumnName)) continue;
            explicitColumnReference = true;
            if (keyColumns.contains(AnnotatedJoinColumn.column(context, table, logicalReferencedColumnName))) continue;
            return 2;
        }
        if (explicitColumnReference) {
            return keyColumns.size() == columns.length ? 1 : 2;
        }
        return 0;
    }

    private static Column column(MetadataBuildingContext context, Table table, String logicalReferencedColumnName) {
        try {
            return new Column(context.getMetadataCollector().getPhysicalColumnName(table, logicalReferencedColumnName));
        }
        catch (MappingException me) {
            throw new MappingException("No column with logical name '" + logicalReferencedColumnName + "' in table '" + table.getName() + "'");
        }
    }

    public void overrideFromReferencedColumnIfNecessary(Column column) {
        Column mappingColumn = this.getMappingColumn();
        if (mappingColumn != null) {
            if (StringHelper.isEmpty(this.sqlType)) {
                this.sqlType = column.getSqlType();
                mappingColumn.setSqlType(this.sqlType);
            }
            mappingColumn.setLength(column.getLength());
            mappingColumn.setPrecision(column.getPrecision());
            mappingColumn.setScale(column.getScale());
        }
    }

    @Override
    public void redefineColumnName(String columnName, String propertyName, boolean applyNamingStrategy) {
        super.redefineColumnName(columnName, null, applyNamingStrategy);
    }

    public static AnnotatedJoinColumn[] buildJoinTableJoinColumns(JoinColumn[] annJoins, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, String propertyName, String mappedBy, MetadataBuildingContext buildingContext) {
        AnnotatedJoinColumn[] joinColumns;
        if (annJoins == null) {
            AnnotatedJoinColumn currentJoinColumn = new AnnotatedJoinColumn();
            currentJoinColumn.setImplicit(true);
            currentJoinColumn.setNullable(false);
            currentJoinColumn.setPropertyHolder(propertyHolder);
            currentJoinColumn.setJoins(secondaryTables);
            currentJoinColumn.setBuildingContext(buildingContext);
            currentJoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            currentJoinColumn.setMappedBy(mappedBy);
            currentJoinColumn.bind();
            joinColumns = new AnnotatedJoinColumn[]{currentJoinColumn};
        } else {
            joinColumns = new AnnotatedJoinColumn[annJoins.length];
            for (JoinColumn annJoin : annJoins) {
                AnnotatedJoinColumn currentJoinColumn = new AnnotatedJoinColumn();
                currentJoinColumn.setImplicit(true);
                currentJoinColumn.setPropertyHolder(propertyHolder);
                currentJoinColumn.setJoins(secondaryTables);
                currentJoinColumn.setBuildingContext(buildingContext);
                currentJoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
                currentJoinColumn.setMappedBy(mappedBy);
                currentJoinColumn.setJoinAnnotation(annJoin, propertyName);
                currentJoinColumn.setNullable(false);
                currentJoinColumn.bind();
                joinColumns[index] = currentJoinColumn;
            }
        }
        return joinColumns;
    }

    public void setMappedBy(String entityName, String jpaEntityName, String logicalTableName, String mappedByProperty) {
        this.mappedByEntityName = entityName;
        this.mappedByJpaEntityName = jpaEntityName;
        this.mappedByTableName = logicalTableName;
        this.mappedByPropertyName = mappedByProperty;
    }

    @Override
    public String toString() {
        return String.format("JoinColumn{logicalColumnName='%s', referencedColumn='%s', mappedBy='%s'}", this.getLogicalColumnName(), this.referencedColumn, this.mappedBy);
    }
}

