/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimestampType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

public class ConnectTimestampType
extends AbstractTimestampType {
    public static final ConnectTimestampType INSTANCE = new ConnectTimestampType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Timestamp"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTimestamp(DateTimeUtils.toZonedDateTimeFromDate((Date)value, ZoneOffset.UTC));
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Date) {
            LocalDateTime localDateTime = DateTimeUtils.toLocalDateTimeFromDate((Date)value);
            if (this.getDialect().isTimeZoneSet()) {
                query.setParameter(index, (Object)localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()));
            } else {
                query.setParameter(index, (Object)localDateTime);
            }
        } else {
            this.throwUnexpectedValue(value);
        }
        return 1;
    }
}

