/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.jdbc.JdbcSinkConnectorTask;
import io.debezium.connector.jdbc.Module;
import io.debezium.connector.jdbc.naming.ColumnNamingStrategy;
import io.debezium.connector.jdbc.naming.DefaultColumnNamingStrategy;
import io.debezium.connector.jdbc.naming.DefaultTableNamingStrategy;
import io.debezium.connector.jdbc.naming.TableNamingStrategy;
import io.debezium.util.Strings;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.c3p0.internal.C3P0ConnectionProvider;
import org.hibernate.tool.schema.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSinkConnectorTask.class);
    private static final String HIBERNATE_PREFIX = "hibernate.";
    private static final String DEFAULT_DATABASE_TIME_ZONE = "UTC";
    public static final String CONNECTION_URL = "connection.url";
    public static final String CONNECTION_USER = "connection.username";
    public static final String CONNECTION_PASSWORD = "connection.password";
    public static final String CONNECTION_POOL_MIN_SIZE = "connection.pool.min_size";
    public static final String CONNECTION_POOL_MAX_SIZE = "connection.pool.max_size";
    public static final String CONNECTION_POOL_ACQUIRE_INCREMENT = "connection.pool.acquire_increment";
    public static final String CONNECTION_POOL_TIMEOUT = "connection.pool.timeout";
    public static final String INSERT_MODE = "insert.mode";
    public static final String DELETE_ENABLED = "delete.enabled";
    public static final String TRUNCATE_ENABLED = "truncate.enabled";
    public static final String TABLE_NAME_FORMAT = "table.name.format";
    public static final String PRIMARY_KEY_MODE = "primary.key.mode";
    public static final String PRIMARY_KEY_FIELDS = "primary.key.fields";
    public static final String SCHEMA_EVOLUTION = "schema.evolution";
    public static final String QUOTE_IDENTIFIERS = "quote.identifiers";
    public static final String DATA_TYPE_MAPPING = "data.type.mapping";
    public static final String TABLE_NAMING_STRATEGY = "table.naming.strategy";
    public static final String COLUMN_NAMING_STRATEGY = "column.naming.strategy";
    public static final String DATABASE_TIME_ZONE = "database.time_zone";
    public static final String POSTGRES_POSTGIS_SCHEMA = "dialect.postgres.postgis.schema";
    public static final String SQLSERVER_IDENTITY_INSERT = "dialect.sqlserver.identity.insert";
    public static final Field CONNECTION_URL_FIELD = Field.create((String)"connection.url").withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).required().withDescription("Valid JDBC URL");
    public static final Field CONNECTION_USER_FIELD = Field.create((String)"connection.username").withDisplayName("User").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).required().withDescription("Name of the database user to be used when connecting to the connection.");
    public static final Field CONNECTION_PASSWORD_FIELD = Field.create((String)"connection.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).required().withDescription("Password of the database user to be used when connecting to the connection.");
    public static final Field CONNECTION_POOL_MIN_SIZE_FIELD = Field.create((String)"connection.pool.min_size").withDisplayName("Connection pool minimum size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5).withDescription("Minimum number of connection in the connection pool");
    public static final Field CONNECTION_POOL_MAX_SIZE_FIELD = Field.create((String)"connection.pool.max_size").withDisplayName("Connection pool maximum size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(32).withDescription("Maximum number of connection in the connection pool");
    public static final Field CONNECTION_POOL_ACQUIRE_INCREMENT_FIELD = Field.create((String)"connection.pool.acquire_increment").withDisplayName("Connection pool acquire increment").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(32).withDescription("Connection pool acquire increment");
    public static final Field CONNECTION_POOL_TIMEOUT_FIELD = Field.create((String)"connection.pool.timeout").withDisplayName("Connection pool timeout").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(1800).withDescription("Connection pool timeout");
    public static final Field INSERT_MODE_FIELD = Field.create((String)"insert.mode").withDisplayName("The insertion mode to use").withEnum(InsertMode.class, (Enum)InsertMode.INSERT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{JdbcSinkConnectorConfig::validateInsertMode}).withDescription("The insertion mode to use. 'insert' - the default mode, uses standard SQL insert statements; 'upsert' - uses upsert semantics for the database if its supported and requires setting primary.key.mode and primary.key.fields;'update' - uses update semantics for the database if its supported.");
    public static final Field DELETE_ENABLED_FIELD = Field.create((String)"delete.enabled").withDisplayName("Controls whether records can be deleted by the connector").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withValidation(new Field.Validator[]{JdbcSinkConnectorConfig::validateDeleteEnabled}).withDescription("Whether to treat `null` record values as deletes. Requires primary.key.mode to be `record.key`.");
    public static final Field TRUNCATE_ENABLED_FIELD = Field.create((String)"truncate.enabled").withDisplayName("Controls whether tables can be truncated by the connector").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withValidation(new Field.Validator[]{JdbcSinkConnectorConfig::validateDeleteEnabled}).withDescription("Whether to process debezium event `t` as truncate statement.");
    public static final Field TABLE_NAME_FORMAT_FIELD = Field.create((String)"table.name.format").withDisplayName("A format string for the table").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)3)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("${topic}").withDescription("A format string for the table, which may contain '${topic}' as a placeholder for the original topic name.");
    public static final Field PRIMARY_KEY_MODE_FIELD = Field.create((String)"primary.key.mode").withDisplayName("The primary key mode").withEnum(PrimaryKeyMode.class, (Enum)PrimaryKeyMode.NONE).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("The primary key mode");
    public static final Field PRIMARY_KEY_FIELDS_FIELD = Field.create((String)"primary.key.fields").withDisplayName("Comma-separated list of primary key field names").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)5)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A comma-separated list of primary key field names. This is interpreted differently depending on primary.key.mode.");
    public static final Field DATABASE_TIME_ZONE_FIELD = Field.create((String)"database.time_zone").withDisplayName("The timezone used when inserting temporal values.").withDefault("UTC").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The timezone used when inserting temporal values. Defaults to UTC.");
    public static final Field SCHEMA_EVOLUTION_FIELD = Field.create((String)"schema.evolution").withDisplayName("Controls how schema evolution is handled by the sink connector").withEnum(SchemaEvolutionMode.class, (Enum)SchemaEvolutionMode.NONE).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls how schema evolution is handled by the sink connector");
    public static final Field QUOTE_IDENTIFIERS_FIELD = Field.create((String)"quote.identifiers").withDisplayName("Controls whether table, column, or other identifiers are quoted").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)8)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("When enabled, table, column, and other identifiers are quoted based on the database dialect. When disabled, only explicit cases where the dialect requires quoting will be used, such as names starting with an underscore.");
    public static final Field TABLE_NAMING_STRATEGY_FIELD = Field.create((String)"table.naming.strategy").withDisplayName("Name of the strategy class that implements the TablingNamingStrategy interface").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(DefaultTableNamingStrategy.class.getName()).withDescription("Name of the strategy class that implements the TableNamingStrategy interface.");
    public static final Field COLUMN_NAMING_STRATEGY_FIELD = Field.create((String)"column.naming.strategy").withDisplayName("Name of the strategy class that implements the ColumnNamingStrategy interface").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(DefaultColumnNamingStrategy.class.getName()).withDescription("Name of the strategy class that implements the ColumnNamingStrategy interface.");
    public static final Field POSTGRES_POSTGIS_SCHEMA_FIELD = Field.create((String)"dialect.postgres.postgis.schema").withDisplayName("Name of the schema where postgis extension is installed").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)3)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault("public").withDescription("Name of the schema where postgis extension is installed. Default is public");
    public static final Field SQLSERVER_IDENTITY_INSERT_FIELD = Field.create((String)"dialect.sqlserver.identity.insert").withDisplayName("Allowing to insert explicit value for identity column in table for SQLSERVER.").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Allowing to insert explicit value for identity column in table for SQLSERVER.");
    protected static final ConfigDefinition CONFIG_DEFINITION = ConfigDefinition.editor().connector(new Field[]{CONNECTION_URL_FIELD, CONNECTION_USER_FIELD, CONNECTION_PASSWORD_FIELD, CONNECTION_POOL_MIN_SIZE_FIELD, CONNECTION_POOL_MAX_SIZE_FIELD, CONNECTION_POOL_ACQUIRE_INCREMENT_FIELD, CONNECTION_POOL_TIMEOUT_FIELD, INSERT_MODE_FIELD, DELETE_ENABLED_FIELD, TRUNCATE_ENABLED_FIELD, TABLE_NAME_FORMAT_FIELD, PRIMARY_KEY_MODE_FIELD, PRIMARY_KEY_FIELDS_FIELD, SCHEMA_EVOLUTION_FIELD, QUOTE_IDENTIFIERS_FIELD, TABLE_NAMING_STRATEGY_FIELD, COLUMN_NAMING_STRATEGY_FIELD, DATABASE_TIME_ZONE_FIELD, POSTGRES_POSTGIS_SCHEMA_FIELD, SQLSERVER_IDENTITY_INSERT_FIELD}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final Configuration config;
    private final InsertMode insertMode;
    private final boolean deleteEnabled;
    private final boolean truncateEnabled;
    private final String tableNameFormat;
    private final PrimaryKeyMode primaryKeyMode;
    private final Set<String> primaryKeyFields;
    private final SchemaEvolutionMode schemaEvolutionMode;
    private final boolean quoteIdentifiers;
    private final TableNamingStrategy tableNamingStrategy;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final String databaseTimezone;
    private final String postgresPostgisSchema;
    private final boolean sqlServerIdentityInsert;

    public JdbcSinkConnectorConfig(Map<String, String> props) {
        this.config = Configuration.from(props);
        this.insertMode = InsertMode.parse(this.config.getString(INSERT_MODE));
        this.deleteEnabled = this.config.getBoolean(DELETE_ENABLED_FIELD);
        this.truncateEnabled = this.config.getBoolean(TRUNCATE_ENABLED_FIELD);
        this.tableNameFormat = this.config.getString(TABLE_NAME_FORMAT_FIELD);
        this.primaryKeyMode = PrimaryKeyMode.parse(this.config.getString(PRIMARY_KEY_MODE_FIELD));
        this.primaryKeyFields = Strings.setOf((String)this.config.getString(PRIMARY_KEY_FIELDS_FIELD), String::new);
        this.schemaEvolutionMode = SchemaEvolutionMode.parse(this.config.getString(SCHEMA_EVOLUTION));
        this.quoteIdentifiers = this.config.getBoolean(QUOTE_IDENTIFIERS_FIELD);
        this.tableNamingStrategy = (TableNamingStrategy)this.config.getInstance(TABLE_NAMING_STRATEGY_FIELD, TableNamingStrategy.class);
        this.columnNamingStrategy = (ColumnNamingStrategy)this.config.getInstance(COLUMN_NAMING_STRATEGY_FIELD, ColumnNamingStrategy.class);
        this.databaseTimezone = this.config.getString(DATABASE_TIME_ZONE_FIELD);
        this.postgresPostgisSchema = this.config.getString(POSTGRES_POSTGIS_SCHEMA_FIELD);
        this.sqlServerIdentityInsert = this.config.getBoolean(SQLSERVER_IDENTITY_INSERT_FIELD);
    }

    public void validate() {
        if (!this.config.validateAndRecord((Iterable)ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + this.getClass().getSimpleName() + "; check the logs for details");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting {} with configuration:", (Object)this.getClass().getSimpleName());
            this.config.withMaskedPasswords().forEach((propName, propValue) -> LOGGER.info("   {} = {}", propName, propValue));
        }
    }

    public boolean validateAndRecord(Iterable<Field> fields, Consumer<String> problems) {
        return this.config.validateAndRecord(fields, problems);
    }

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public InsertMode getInsertMode() {
        return this.insertMode;
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public boolean isTruncateEnabled() {
        return this.truncateEnabled;
    }

    public String getTableNameFormat() {
        return this.tableNameFormat;
    }

    public PrimaryKeyMode getPrimaryKeyMode() {
        return this.primaryKeyMode;
    }

    public Set<String> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public SchemaEvolutionMode getSchemaEvolutionMode() {
        return this.schemaEvolutionMode;
    }

    public boolean isQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public boolean isSqlServerIdentityInsert() {
        return this.sqlServerIdentityInsert;
    }

    public TableNamingStrategy getTableNamingStrategy() {
        return this.tableNamingStrategy;
    }

    public ColumnNamingStrategy getColumnNamingStrategy() {
        return this.columnNamingStrategy;
    }

    public String getDatabaseTimeZone() {
        return this.databaseTimezone;
    }

    public String getPostgresPostgisSchema() {
        return this.postgresPostgisSchema;
    }

    public org.hibernate.cfg.Configuration getHibernateConfiguration() {
        org.hibernate.cfg.Configuration hibernateConfig = new org.hibernate.cfg.Configuration();
        hibernateConfig.setProperty("hibernate.connection.provider_class", C3P0ConnectionProvider.class.getName());
        hibernateConfig.setProperty("hibernate.connection.url", this.config.getString(CONNECTION_URL_FIELD));
        hibernateConfig.setProperty("hibernate.connection.username", this.config.getString(CONNECTION_USER_FIELD));
        hibernateConfig.setProperty("hibernate.connection.password", this.config.getString(CONNECTION_PASSWORD_FIELD));
        hibernateConfig.setProperty("hibernate.c3p0.min_size", this.config.getString(CONNECTION_POOL_MIN_SIZE_FIELD));
        hibernateConfig.setProperty("hibernate.c3p0.max_size", this.config.getString(CONNECTION_POOL_MAX_SIZE_FIELD));
        hibernateConfig.setProperty("hibernate.c3p0.acquire_increment", this.config.getString(CONNECTION_POOL_ACQUIRE_INCREMENT_FIELD));
        hibernateConfig.setProperty("hibernate.globally_quoted_identifiers", Boolean.toString(this.config.getBoolean(QUOTE_IDENTIFIERS_FIELD)));
        hibernateConfig.setProperty("hibernate.jdbc.time_zone", this.getDatabaseTimeZone());
        if (LOGGER.isDebugEnabled()) {
            hibernateConfig.setProperty("hibernate.show_sql", Boolean.toString(true));
        }
        this.config.subset(HIBERNATE_PREFIX, false).forEach((key, value) -> hibernateConfig.setProperty(key, value));
        hibernateConfig.setProperty("hibernate.hbm2ddl.auto", Action.NONE.getExternalJpaName());
        return hibernateConfig;
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static int validateInsertMode(Configuration config, Field field, Field.ValidationOutput problems) {
        InsertMode insertMode = InsertMode.parse(config.getString(field));
        if (InsertMode.UPSERT.equals((Object)insertMode)) {
            PrimaryKeyMode primaryKeyMode;
            if (!config.hasKey(PRIMARY_KEY_MODE) && !config.hasKey(PRIMARY_KEY_FIELDS)) {
                LOGGER.error("When using UPSERT, please define '{}' and '{}'.", (Object)PRIMARY_KEY_MODE, (Object)PRIMARY_KEY_FIELDS);
                return 1;
            }
            if (!config.hasKey(PRIMARY_KEY_MODE)) {
                LOGGER.error("When using UPSERT, please define '{}'.", (Object)PRIMARY_KEY_MODE);
                return 1;
            }
            if (!config.hasKey(PRIMARY_KEY_FIELDS) && PrimaryKeyMode.RECORD_VALUE.equals((Object)(primaryKeyMode = PrimaryKeyMode.parse(config.getString(PRIMARY_KEY_MODE_FIELD))))) {
                LOGGER.error("When using UPSERT, please define '{}'.", (Object)PRIMARY_KEY_FIELDS);
                return 1;
            }
        }
        return 0;
    }

    private static int validateDeleteEnabled(Configuration config, Field field, Field.ValidationOutput problems) {
        PrimaryKeyMode primaryKeyMode;
        if (config.getBoolean(field) && !PrimaryKeyMode.RECORD_KEY.equals((Object)(primaryKeyMode = PrimaryKeyMode.parse(config.getString(PRIMARY_KEY_MODE))))) {
            LOGGER.error("When '{}' is set to 'true', the '{}' option must be set to '{}'.", new Object[]{DELETE_ENABLED, PRIMARY_KEY_MODE, PrimaryKeyMode.RECORD_KEY.getValue()});
            return 1;
        }
        return 0;
    }

    public static enum InsertMode implements EnumeratedValue
    {
        INSERT("insert"),
        UPSERT("upsert"),
        UPDATE("update");

        private String mode;

        private InsertMode(String mode) {
            this.mode = mode;
        }

        public static InsertMode parse(String value) {
            for (InsertMode option : InsertMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return INSERT;
        }

        public String getValue() {
            return this.mode;
        }
    }

    public static enum PrimaryKeyMode implements EnumeratedValue
    {
        NONE("none"),
        KAFKA("kafka"),
        RECORD_KEY("record_key"),
        RECORD_VALUE("record_value"),
        RECORD_HEADER("record_header");

        private String mode;

        private PrimaryKeyMode(String mode) {
            this.mode = mode;
        }

        public static PrimaryKeyMode parse(String value) {
            for (PrimaryKeyMode option : PrimaryKeyMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return RECORD_KEY;
        }

        public String getValue() {
            return this.mode;
        }
    }

    public static enum SchemaEvolutionMode implements EnumeratedValue
    {
        NONE("none"),
        BASIC("basic");

        private String mode;

        private SchemaEvolutionMode(String mode) {
            this.mode = mode;
        }

        public static SchemaEvolutionMode parse(String value) {
            for (SchemaEvolutionMode option : SchemaEvolutionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return NONE;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

