/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter;

public enum SinkType {
    MYSQL("mysql"),
    POSTGRES("postgres"),
    SQLSERVER("sqlserver"),
    ORACLE("oracle"),
    DB2("db2");

    private final String value;

    private SinkType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean is(SinkType ... types) {
        for (SinkType type : types) {
            if (!this.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public static SinkType parse(String value) {
        for (SinkType type : SinkType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalStateException("Unknown source type: " + value);
    }
}

