/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractDateType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

public class ConnectDateType
extends AbstractDateType {
    public static final ConnectDateType INSTANCE = new ConnectDateType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Date"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedDate(DateTimeUtils.toLocalDateFromDate((Date)value));
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Date) {
            query.setParameter(index, (Object)DateTimeUtils.toLocalDateFromDate((Date)value));
        } else {
            this.throwUnexpectedValue(value);
        }
        return 1;
    }
}

