/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.sqlserver;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.sqlserver.BitType;
import io.debezium.connector.jdbc.dialect.sqlserver.SqlServerZonedTimeType;
import io.debezium.connector.jdbc.dialect.sqlserver.XmlType;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;

public class SqlServerDatabaseDialect
extends GeneralDatabaseDialect {
    private SqlServerDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    public String getInsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        String insertStatement = super.getInsertStatement(table, record);
        return this.wrapWithIdentityInsert(table, insertStatement);
    }

    @Override
    public String getAlterTablePrefix() {
        return "ADD ";
    }

    @Override
    public String getAlterTableSuffix() {
        return "";
    }

    private String wrapWithIdentityInsert(TableDescriptor table, String sqlStatement) {
        if (!table.hasAutoGeneratedIdentityColumn() || !this.getConfig().isSqlServerIdentityInsert()) {
            return sqlStatement;
        }
        String qualifiedTableName = this.getQualifiedTableName(table.getId());
        return "SET IDENTITY_INSERT " + qualifiedTableName + " ON ;" + sqlStatement + ";" + "SET IDENTITY_INSERT " + qualifiedTableName + " OFF ;";
    }

    @Override
    protected Optional<String> getDatabaseTimeZoneQuery() {
        return Optional.of("SELECT CURRENT_TIMEZONE()");
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        this.registerType(BitType.INSTANCE);
        this.registerType(XmlType.INSTANCE);
        this.registerType(SqlServerZonedTimeType.INSTANCE);
    }

    @Override
    public String getTimeQueryBinding() {
        return "cast(? as time(7))";
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return 900;
    }

    @Override
    public int getMaxTimePrecision() {
        return 7;
    }

    @Override
    public int getMaxTimestampPrecision() {
        return 7;
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("MERGE INTO ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" WITH (HOLDLOCK) AS TARGET USING (SELECT ");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, this.columnQueryBindingFromField((String)name, table, record) + " AS ", record));
        builder.append(") AS INCOMING ON (");
        builder.appendList(" AND ", record.getKeyFieldNames(), name -> {
            String columnName = this.columnNameFromField((String)name, record);
            return "TARGET." + columnName + "=INCOMING." + columnName;
        });
        builder.append(")");
        if (!record.getNonKeyFieldNames().isEmpty()) {
            builder.append(" WHEN MATCHED THEN UPDATE SET ");
            builder.appendList(",", record.getNonKeyFieldNames(), name -> {
                String columnName = this.columnNameFromField((String)name, record);
                return columnName + "=INCOMING." + columnName;
            });
        }
        builder.append(" WHEN NOT MATCHED THEN INSERT (");
        builder.appendLists(", ", record.getNonKeyFieldNames(), record.getKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(",", record.getNonKeyFieldNames(), record.getKeyFieldNames(), name -> this.columnNameFromField((String)name, "INCOMING.", record));
        builder.append(")");
        builder.append(";");
        return this.wrapWithIdentityInsert(table, builder.build());
    }

    @Override
    public String getByteArrayFormat() {
        return "CONVERT(VARBINARY, '0x%s')";
    }

    public static class SqlServerDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof SQLServerDialect;
        }

        @Override
        public Class<?> name() {
            return SqlServerDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            return new SqlServerDatabaseDialect(config, sessionFactory);
        }
    }
}

