/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

public abstract class AbstractDebeziumTimeType
extends AbstractTimeType {
    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getTimeQueryBinding();
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        LocalTime localTime = this.getLocalTime((Number)value);
        if (dialect.isTimeZoneSet()) {
            return this.getDialect().getFormattedDateTime(localTime.atDate(LocalDate.now()).atZone(this.getDatabaseTimeZone().toZoneId()));
        }
        return dialect.getFormattedTime(localTime);
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Number) {
            LocalTime localTime = this.getLocalTime((Number)value);
            LocalDateTime localDateTime = localTime.atDate(LocalDate.now());
            if (this.getDialect().isTimeZoneSet()) {
                query.setParameter(index, (Object)localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()));
            } else {
                query.setParameter(index, (Object)localDateTime);
            }
        } else {
            this.throwUnexpectedValue(value);
        }
        return 1;
    }

    protected abstract LocalTime getLocalTime(Number var1);
}

