/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.type.AbstractType;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.query.Query;

public abstract class AbstractGeoType
extends AbstractType {
    public static final String SRID = "srid";
    public static final String WKB = "wkb";

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
            return 1;
        }
        if (value instanceof Struct) {
            Integer srid = Optional.ofNullable(((Struct)value).getInt32(SRID)).orElse(0);
            byte[] wkb = ((Struct)value).getBytes(WKB);
            query.setParameter(index, (Object)wkb);
            query.setParameter(index + 1, (Object)srid);
            return 2;
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

