/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

class IntervalType
extends AbstractType {
    public static final IntervalType INSTANCE = new IntervalType();

    IntervalType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.MicroDuration"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return "cast(? as interval)";
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return "interval";
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        if (value instanceof Long) {
            double doubleValue = ((Long)value).doubleValue() / 1000000.0;
            return String.format("'%d seconds'", (long)doubleValue);
        }
        return null;
    }

    @Override
    public int bind(Query<?> query, int index, Schema schema, Object value) {
        if (value != null && Long.class.isAssignableFrom(value.getClass())) {
            double doubleValue = ((Long)value).doubleValue() / 1000000.0;
            query.setParameter(index, (Object)((long)doubleValue + " seconds"));
        } else {
            query.setParameter(index, value);
        }
        return 1;
    }
}

