/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class SelectableMappingImpl
extends SqlTypedMappingImpl
implements SelectableMapping {
    private final String containingTableExpression;
    private final String selectionExpression;
    private final String customReadExpression;
    private final String customWriteExpression;
    private final boolean isFormula;

    public SelectableMappingImpl(String containingTableExpression, String selectionExpression, String customReadExpression, String customWriteExpression, String columnDefinition, Long length, Integer precision, Integer scale, boolean isFormula, JdbcMapping jdbcMapping) {
        super(columnDefinition, length, precision, scale, jdbcMapping);
        this.containingTableExpression = containingTableExpression == null ? null : containingTableExpression.intern();
        this.selectionExpression = selectionExpression == null ? null : selectionExpression.intern();
        this.customReadExpression = customReadExpression == null ? null : customReadExpression.intern();
        this.customWriteExpression = customWriteExpression == null ? null : customWriteExpression.intern();
        this.isFormula = isFormula;
    }

    public static SelectableMapping from(String containingTableExpression, Selectable selectable, JdbcMapping jdbcMapping, TypeConfiguration typeConfiguration, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        Integer scale;
        Integer precision;
        Long length;
        String columnDefinition;
        String columnExpression;
        if (selectable.isFormula()) {
            columnExpression = selectable.getTemplate(dialect, typeConfiguration, sqmFunctionRegistry);
            columnDefinition = null;
            length = null;
            precision = null;
            scale = null;
        } else {
            Column column = (Column)selectable;
            columnExpression = selectable.getText(dialect);
            columnDefinition = column.getSqlType();
            length = column.getLength();
            precision = column.getPrecision();
            scale = column.getScale();
        }
        return new SelectableMappingImpl(containingTableExpression, columnExpression, selectable.getCustomReadExpression(), selectable.getCustomWriteExpression(), columnDefinition, length, precision, scale, selectable.isFormula(), jdbcMapping);
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.selectionExpression;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }
}

