/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractNaturalIdLoader;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.CompoundNaturalIdMapping;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;

public class CompoundNaturalIdLoader<T>
extends AbstractNaturalIdLoader<T> {
    public CompoundNaturalIdLoader(CompoundNaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        super(naturalIdMapping, entityDescriptor);
    }

    @Override
    protected void applyNaturalIdRestriction(Object bindValue, TableGroup rootTableGroup, Consumer<Predicate> predicateConsumer, BiConsumer<JdbcParameter, JdbcParameterBinding> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState, SharedSessionContractImplementor session) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        SessionFactoryImplementor factory = session.getFactory();
        if (bindValue == null) {
            List<SingularAttributeMapping> naturalIdAttributes = this.naturalIdMapping().getNaturalIdAttributes();
            for (int i = 0; i < naturalIdAttributes.size(); ++i) {
                naturalIdAttributes.get(i).forEachSelectable((index, selectable) -> {
                    Expression columnRef = this.resolveColumnReference(rootTableGroup, selectable, sqlExpressionResolver, factory);
                    predicateConsumer.accept(new NullnessPredicate(columnRef));
                });
            }
            return;
        }
        this.naturalIdMapping().breakDownJdbcValues(bindValue, (jdbcValue, jdbcValueMapping) -> {
            Expression columnReference = this.resolveColumnReference(rootTableGroup, jdbcValueMapping, sqlExpressionResolver, factory);
            if (jdbcValue == null) {
                predicateConsumer.accept(new NullnessPredicate(columnReference));
            } else {
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcValueMapping.getJdbcMapping());
                ComparisonPredicate predicate = new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter);
                predicateConsumer.accept(predicate);
                jdbcParameterConsumer.accept(jdbcParameter, new JdbcParameterBindingImpl(jdbcValueMapping.getJdbcMapping(), jdbcValue));
            }
        }, session);
    }
}

