/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.util;

import io.debezium.connector.jdbc.util.SinkRecordBuilder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.sink.SinkRecord;

public interface SinkRecordFactory {
    public boolean isFlattened();

    default public SinkRecordBuilder.SinkRecordTypeBuilder createBuilder() {
        return SinkRecordBuilder.create().flat(this.isFlattened());
    }

    default public SinkRecordBuilder.SinkRecordTypeBuilder updateBuilder() {
        return SinkRecordBuilder.update().flat(this.isFlattened());
    }

    default public SinkRecordBuilder.SinkRecordTypeBuilder deleteBuilder() {
        return SinkRecordBuilder.delete().flat(this.isFlattened());
    }

    default public Schema primitiveKeySchema() {
        return SchemaBuilder.int32().build();
    }

    default public Schema basicKeySchema() {
        return SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).build();
    }

    default public Schema multipleKeySchema() {
        return SchemaBuilder.struct().field("id1", Schema.INT8_SCHEMA).field("id2", Schema.INT32_SCHEMA).build();
    }

    default public Schema basicSourceSchema() {
        return SchemaBuilder.struct().field("ts_ms", Schema.OPTIONAL_INT32_SCHEMA).field("schema", Schema.OPTIONAL_STRING_SCHEMA).field("db", Schema.OPTIONAL_STRING_SCHEMA).field("table", Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    default public Schema basicRecordSchema() {
        return SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    default public Schema multipleKeyRecordSchema() {
        return SchemaBuilder.struct().field("id1", Schema.INT8_SCHEMA).field("id2", Schema.INT32_SCHEMA).field("name", Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    default public Schema allKafkaSchemaTypesSchema() {
        return SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("col_int8", Schema.INT8_SCHEMA).field("col_int8_optional", Schema.OPTIONAL_INT8_SCHEMA).field("col_int16", Schema.INT16_SCHEMA).field("col_int16_optional", Schema.OPTIONAL_INT16_SCHEMA).field("col_int32", Schema.INT32_SCHEMA).field("col_int32_optional", Schema.OPTIONAL_INT32_SCHEMA).field("col_int64", Schema.INT64_SCHEMA).field("col_int64_optional", Schema.OPTIONAL_INT64_SCHEMA).field("col_float32", Schema.FLOAT32_SCHEMA).field("col_float32_optional", Schema.OPTIONAL_FLOAT32_SCHEMA).field("col_float64", Schema.FLOAT64_SCHEMA).field("col_float64_optional", Schema.OPTIONAL_FLOAT64_SCHEMA).field("col_bool", Schema.BOOLEAN_SCHEMA).field("col_bool_optional", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("col_string", Schema.STRING_SCHEMA).field("col_string_optional", Schema.OPTIONAL_STRING_SCHEMA).field("col_bytes", Schema.BYTES_SCHEMA).field("col_bytes_optional", Schema.OPTIONAL_BYTES_SCHEMA).build();
    }

    default public Schema allKafkaSchemaTypesSchemaWithDefaults() {
        return SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("col_int8", SchemaBuilder.int8().defaultValue((Object)2).build()).field("col_int8_optional", SchemaBuilder.int16().optional().defaultValue((Object)2).build()).field("col_int16", Schema.INT16_SCHEMA).field("col_int16_optional", Schema.OPTIONAL_INT16_SCHEMA).field("col_int32", Schema.INT32_SCHEMA).field("col_int32_optional", Schema.OPTIONAL_INT32_SCHEMA).field("col_int64", Schema.INT64_SCHEMA).field("col_int64_optional", Schema.OPTIONAL_INT64_SCHEMA).field("col_float32", Schema.FLOAT32_SCHEMA).field("col_float32_optional", Schema.OPTIONAL_FLOAT32_SCHEMA).field("col_float64", Schema.FLOAT64_SCHEMA).field("col_float64_optional", Schema.OPTIONAL_FLOAT64_SCHEMA).field("col_bool", Schema.BOOLEAN_SCHEMA).field("col_bool_optional", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("col_string", Schema.STRING_SCHEMA).field("col_string_optional", Schema.OPTIONAL_STRING_SCHEMA).field("col_bytes", Schema.BYTES_SCHEMA).field("col_bytes_optional", Schema.OPTIONAL_BYTES_SCHEMA).build();
    }

    default public Schema allKafkaSchemaTypesSchemaWithOptionalDefaultValues() {
        String text = "Hello World";
        return SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("col_int8", Schema.INT8_SCHEMA).field("col_int8_optional", SchemaBuilder.int8().optional().defaultValue((Object)10).build()).field("col_int16", Schema.INT16_SCHEMA).field("col_int16_optional", SchemaBuilder.int16().optional().defaultValue((Object)15).build()).field("col_int32", Schema.INT32_SCHEMA).field("col_int32_optional", SchemaBuilder.int32().optional().defaultValue((Object)1024).build()).field("col_int64", Schema.INT64_SCHEMA).field("col_int64_optional", SchemaBuilder.int64().optional().defaultValue((Object)1024L).build()).field("col_float32", Schema.FLOAT32_SCHEMA).field("col_float32_optional", SchemaBuilder.float32().optional().defaultValue((Object)Float.valueOf(3.14f)).build()).field("col_float64", Schema.FLOAT64_SCHEMA).field("col_float64_optional", SchemaBuilder.float64().optional().defaultValue((Object)3.14).build()).field("col_bool", Schema.BOOLEAN_SCHEMA).field("col_bool_optional", SchemaBuilder.bool().optional().defaultValue((Object)true).build()).field("col_string", Schema.STRING_SCHEMA).field("col_string_optional", SchemaBuilder.string().optional().defaultValue((Object)"Hello World").build()).field("col_bytes", Schema.BYTES_SCHEMA).field("col_bytes_optional", SchemaBuilder.bytes().optional().defaultValue((Object)"Hello World".getBytes(StandardCharsets.UTF_8)).build()).build();
    }

    default public SinkRecord createRecordNoKey(String topicName) {
        return SinkRecordBuilder.create().flat(this.isFlattened()).name("prefix").topic(topicName).recordSchema(this.basicRecordSchema()).sourceSchema(this.basicSourceSchema()).after("id", (byte)1).after("name", "John Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord createRecord(String topicName) {
        return this.createRecord(topicName, (byte)1);
    }

    default public SinkRecord createRecord(String topicName, byte key) {
        return SinkRecordBuilder.create().flat(this.isFlattened()).name("prefix").topic(topicName).offset(1).partition(0).keySchema(this.basicKeySchema()).recordSchema(this.basicRecordSchema()).sourceSchema(this.basicSourceSchema()).key("id", key).after("id", key).after("name", "John Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord createRecordWithSchemaValue(String topicName, byte key, List<String> fieldNames, List<Schema> fieldSchemas, List<Object> values) {
        int i;
        SinkRecordBuilder.SinkRecordTypeBuilder basicSchemaBuilder = SinkRecordBuilder.create().flat(this.isFlattened()).name("prefix").topic(topicName).offset(1).partition(0).keySchema(this.basicKeySchema()).sourceSchema(this.basicSourceSchema()).source("ts_ms", (int)Instant.now().getEpochSecond()).key("id", key);
        SchemaBuilder recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA);
        for (i = 0; i < fieldNames.size(); ++i) {
            recordSchema.field(fieldNames.get(i), fieldSchemas.get(i));
        }
        basicSchemaBuilder.recordSchema((Schema)recordSchema);
        basicSchemaBuilder.after("id", key);
        for (i = 0; i < values.size(); ++i) {
            basicSchemaBuilder.after(fieldNames.get(i), values.get(i));
        }
        return basicSchemaBuilder.build();
    }

    default public SinkRecord createRecordWithSchemaValue(String topicName, byte key, String fieldName, Schema fieldSchema, Object value) {
        return SinkRecordBuilder.create().flat(this.isFlattened()).name("prefix").topic(topicName).offset(1).partition(0).keySchema(this.basicKeySchema()).recordSchema(SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field(fieldName, fieldSchema).build()).sourceSchema(this.basicSourceSchema()).key("id", key).after("id", key).after(fieldName, value).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord createRecord(String topicName, byte key, String database, String schema, String table) {
        return SinkRecordBuilder.create().flat(this.isFlattened()).name("prefix").topic(topicName).offset(1).partition(0).keySchema(this.basicKeySchema()).recordSchema(this.basicRecordSchema()).sourceSchema(this.basicSourceSchema()).key("id", key).after("id", key).after("name", "John Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).source("db", database).source("schema", schema).source("table", table).build();
    }

    default public SinkRecord createRecordMultipleKeyColumns(String topicName) {
        return SinkRecordBuilder.create().flat(this.isFlattened()).name("prefix").topic(topicName).keySchema(this.multipleKeySchema()).recordSchema(this.multipleKeyRecordSchema()).sourceSchema(this.basicSourceSchema()).key("id1", (byte)1).key("id2", 10).after("id1", (byte)1).after("id2", 10).after("name", "John Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord updateRecord(String topicName) {
        return SinkRecordBuilder.update().flat(this.isFlattened()).name("prefix").topic(topicName).keySchema(this.basicKeySchema()).recordSchema(this.basicRecordSchema()).sourceSchema(this.basicSourceSchema()).key("id", (byte)1).before("id", (byte)1).before("name", "John Doe").after("id", (byte)1).after("name", "Jane Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord updateRecordWithSchemaValue(String topicName, byte key, String fieldName, Schema fieldSchema, Object value) {
        return SinkRecordBuilder.update().flat(this.isFlattened()).name("prefix").topic(topicName).offset(1).partition(0).keySchema(this.basicKeySchema()).recordSchema(SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field(fieldName, fieldSchema).build()).sourceSchema(this.basicSourceSchema()).key("id", key).before("id", key).before(fieldName, value).after("id", key).after(fieldName, value).source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord deleteRecord(String topicName) {
        return SinkRecordBuilder.delete().flat(this.isFlattened()).name("prefix").topic(topicName).keySchema(this.basicKeySchema()).recordSchema(this.basicRecordSchema()).sourceSchema(this.basicSourceSchema()).key("id", (byte)1).before("id", (byte)1).before("name", "John Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord deleteRecordMultipleKeyColumns(String topicName) {
        return SinkRecordBuilder.delete().flat(this.isFlattened()).name("prefix").topic(topicName).keySchema(this.multipleKeySchema()).recordSchema(this.multipleKeyRecordSchema()).sourceSchema(this.basicSourceSchema()).key("id1", (byte)1).key("id2", 10).before("id1", (byte)1).before("id2", 10).before("name", "John Doe").source("ts_ms", (int)Instant.now().getEpochSecond()).build();
    }

    default public SinkRecord tombstoneRecord(String topicName) {
        return SinkRecordBuilder.tombstone().topic(topicName).keySchema(this.basicKeySchema()).key("id", (byte)1).build();
    }
}

