/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.postgres.BitType;
import io.debezium.connector.jdbc.dialect.postgres.CaseInsensitiveTextType;
import io.debezium.connector.jdbc.dialect.postgres.CidrType;
import io.debezium.connector.jdbc.dialect.postgres.EnumType;
import io.debezium.connector.jdbc.dialect.postgres.GeographyType;
import io.debezium.connector.jdbc.dialect.postgres.GeometryType;
import io.debezium.connector.jdbc.dialect.postgres.InetType;
import io.debezium.connector.jdbc.dialect.postgres.IntervalType;
import io.debezium.connector.jdbc.dialect.postgres.JsonType;
import io.debezium.connector.jdbc.dialect.postgres.LtreeType;
import io.debezium.connector.jdbc.dialect.postgres.MacAddressType;
import io.debezium.connector.jdbc.dialect.postgres.MapToHstoreType;
import io.debezium.connector.jdbc.dialect.postgres.MoneyType;
import io.debezium.connector.jdbc.dialect.postgres.OidType;
import io.debezium.connector.jdbc.dialect.postgres.PointType;
import io.debezium.connector.jdbc.dialect.postgres.RangeType;
import io.debezium.connector.jdbc.dialect.postgres.SerialType;
import io.debezium.connector.jdbc.dialect.postgres.TimeWithTimezoneType;
import io.debezium.connector.jdbc.dialect.postgres.UuidType;
import io.debezium.connector.jdbc.dialect.postgres.XmlType;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.connector.jdbc.relational.TableId;
import io.debezium.connector.jdbc.type.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;

public class PostgresDatabaseDialect
extends GeneralDatabaseDialect {
    private PostgresDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    public int getMaxTimestampPrecision() {
        return 6;
    }

    @Override
    public boolean tableExists(Connection connection, TableId tableId) throws SQLException {
        if (!this.getConfig().isQuoteIdentifiers()) {
            tableId = tableId.toLowerCase();
        }
        return super.tableExists(connection, tableId);
    }

    @Override
    public TableDescriptor readTable(Connection connection, TableId tableId) throws SQLException {
        if (!this.getConfig().isQuoteIdentifiers()) {
            tableId = tableId.toLowerCase();
        }
        return super.readTable(connection, tableId);
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" (");
        builder.appendLists(",", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(",", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, table, record));
        builder.append(") ON CONFLICT (");
        builder.appendList(",", record.getKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        if (record.getNonKeyFieldNames().isEmpty()) {
            builder.append(") DO NOTHING");
        } else {
            builder.append(") DO UPDATE SET ");
            builder.appendList(",", record.getNonKeyFieldNames(), name -> {
                String columnNme = this.columnNameFromField((String)name, record);
                return columnNme + "=EXCLUDED." + columnNme;
            });
        }
        return builder.build();
    }

    @Override
    public String getQueryBindingWithValueCast(ColumnDescriptor column, Schema schema, Type type) {
        if (schema.type() == Schema.Type.STRING) {
            String typeName = column.getTypeName().toLowerCase();
            if ("uuid".equals(typeName)) {
                return "cast(? as uuid)";
            }
            if ("json".equals(typeName)) {
                return "cast(? as json)";
            }
            if ("jsonb".equals(typeName)) {
                return "cast(? as jsonb)";
            }
        }
        return super.getQueryBindingWithValueCast(column, schema, type);
    }

    @Override
    public String getByteArrayFormat() {
        return "'\\x%s'";
    }

    @Override
    public String getFormattedBoolean(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    @Override
    public String getFormattedDateTimeWithNanos(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedTime(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_TIME.format(value));
    }

    @Override
    protected Optional<String> getDatabaseTimeZoneQuery() {
        return Optional.of("SELECT CURRENT_SETTING('TIMEZONE')");
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        this.registerType(TimeWithTimezoneType.INSTANCE);
        this.registerType(IntervalType.INSTANCE);
        this.registerType(SerialType.INSTANCE);
        this.registerType(BitType.INSTANCE);
        this.registerType(JsonType.INSTANCE);
        this.registerType(UuidType.INSTANCE);
        this.registerType(EnumType.INSTANCE);
        this.registerType(PointType.INSTANCE);
        this.registerType(GeometryType.INSTANCE);
        this.registerType(GeographyType.INSTANCE);
        this.registerType(MoneyType.INSTANCE);
        this.registerType(XmlType.INSTANCE);
        this.registerType(LtreeType.INSTANCE);
        this.registerType(MapToHstoreType.INSTANCE);
        this.registerType(RangeType.INSTANCE);
        this.registerType(CidrType.INSTANCE);
        this.registerType(MacAddressType.INSTANCE);
        this.registerType(InetType.INSTANCE);
        this.registerType(CaseInsensitiveTextType.INSTANCE);
        this.registerType(OidType.INSTANCE);
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected String resolveColumnNameFromField(String fieldName) {
        String columnName = super.resolveColumnNameFromField(fieldName);
        if (!this.getConfig().isQuoteIdentifiers() && !this.getIdentifierHelper().toIdentifier(columnName).isQuoted()) {
            columnName = columnName.toLowerCase();
        }
        return columnName;
    }

    public static class PostgresDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect;
        }

        @Override
        public Class<?> name() {
            return PostgresDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            return new PostgresDatabaseDialect(config, sessionFactory);
        }
    }
}

