/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractDateType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

public class DateType
extends AbstractDateType {
    public static final DateType INSTANCE = new DateType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.Date"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedDate(DateTimeUtils.toLocalDateOfEpochDays(((Number)value).longValue()));
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Number) {
            query.setParameter(index, (Object)DateTimeUtils.toLocalDateOfEpochDays(((Number)value).longValue()));
        } else {
            this.throwUnexpectedValue(value);
        }
    }
}

