/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.connect.AbstractConnectSchemaType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public class ConnectBytesType
extends AbstractConnectSchemaType {
    public static final ConnectBytesType INSTANCE = new ConnectBytesType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"BYTES"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return String.format(dialect.getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
        if (columnSize > 0) {
            return dialect.getTypeName(-3, Size.length((long)columnSize));
        }
        if (key) {
            return dialect.getTypeName(-3, Size.length((long)dialect.getMaxVarbinaryLength()));
        }
        return dialect.getTypeName(-3);
    }
}

