/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.sqlserver;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import java.math.BigInteger;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.Query;

class BitType
extends AbstractType {
    public static final BitType INSTANCE = new BitType();

    BitType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Bits"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema) {
        if ("io.debezium.data.Bits".equals(schema.name())) {
            int bitSize = Integer.parseInt((String)schema.parameters().get("length"));
            return String.format("cast(? as %s)", bitSize > 1 ? String.format("varbinary(%d)", bitSize) : "bit");
        }
        return "cast(? as varbinary)";
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return String.format(dialect.getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        if ("io.debezium.data.Bits".equals(schema.name())) {
            int bitSize = Integer.parseInt((String)schema.parameters().get("length"));
            if (bitSize == 1) {
                return dialect.getTypeName(-7);
            }
            return dialect.getTypeName(-3, Size.length((long)bitSize));
        }
        return dialect.getTypeName(-3);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof byte[]) {
            BigInteger bigIntegerValue = new BigInteger((byte[])value);
            query.setParameter(index, (Object)bigIntegerValue.intValue());
        } else {
            this.throwUnexpectedValue(value);
        }
    }
}

