/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.api.TableColumnAssert;
import org.assertj.db.type.ValueType;
import org.fest.assertions.Assertions;
import org.fest.assertions.Index;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public abstract class AbstractJdbcSinkPrimaryKeyModeTest
extends AbstractJdbcSinkTest {
    public AbstractJdbcSinkPrimaryKeyModeTest(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithNoPrimaryKeyColumnsWithPrimaryKeyModeNone(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.NONE.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, new String[0]);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithNoPrimaryKeyColumnsWithPrimaryKeyModeKafka(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.KAFKA.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "__connect_topic", ValueType.TEXT, topicName);
        this.getSink().assertColumnType(tableAssert, "__connect_partition", ValueType.NUMBER, 0);
        this.getSink().assertColumnType(tableAssert, "__connect_offset", ValueType.NUMBER, 0);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "__connect_topic", "__connect_partition", "__connect_offset");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnWithPrimaryKeyModeKafka(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.KAFKA.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "__connect_topic", ValueType.TEXT, topicName);
        this.getSink().assertColumnType(tableAssert, "__connect_partition", ValueType.NUMBER, 0);
        this.getSink().assertColumnType(tableAssert, "__connect_offset", ValueType.NUMBER, 1L);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "__connect_topic", "__connect_partition", "__connect_offset");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnWithPrimaryKeyModeRecordKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        ((TableColumnAssert)((TableColumnAssert)((TableColumnAssert)((TableColumnAssert)((TableColumnAssert)((TableAssert)TestHelper.assertTable(this.dataSource(), destinationTableName).exists().hasNumberOfColumns(2)).column("id")).isNumber(false)).hasValues(new Number[]{(byte)1})).column("name")).isText(false)).hasValues(new String[]{"John Doe"});
        this.assertHasPrimaryKeyColumns(destinationTableName, "id");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnsWithPrimaryKeyModeRecordKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordMultipleKeyColumns(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id1", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "id2", ValueType.NUMBER, 10);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "id1", "id2");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnWithPrimaryKeyModeRecordHeader(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_HEADER.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        createRecord = new SinkRecord(createRecord.topic(), createRecord.kafkaPartition().intValue(), null, null, createRecord.valueSchema(), createRecord.value(), createRecord.kafkaOffset());
        createRecord.headers().addInt("id", 1);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        ((TableColumnAssert)((TableColumnAssert)((TableColumnAssert)((TableColumnAssert)((TableColumnAssert)((TableAssert)TestHelper.assertTable(this.dataSource(), destinationTableName).exists().hasNumberOfColumns(2)).column("id")).isNumber(false)).hasValues(new Number[]{(byte)1})).column("name")).isText(false)).hasValues(new String[]{"John Doe"});
        this.assertHasPrimaryKeyColumns(destinationTableName, "id");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnsWithPrimaryKeyModeRecordHeader(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_HEADER.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordMultipleKeyColumns(topicName);
        createRecord = new SinkRecord(createRecord.topic(), createRecord.kafkaPartition().intValue(), null, null, createRecord.valueSchema(), createRecord.value(), createRecord.kafkaOffset());
        createRecord.headers().addInt("id1", 1);
        createRecord.headers().addInt("id2", 10);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id1", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "id2", ValueType.NUMBER, 10);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "id1", "id2");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithNoPrimaryKeyColumnsWithPrimaryKeyModeRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id,name");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "id", "name");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnWithPrimaryKeyModeRecordValueWithNoFieldsSpecified(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        try {
            this.consume(factory.createRecord(topicName));
        }
        catch (Exception e) {
            Assertions.assertThat((String)TestHelper.getRootCause(e).getMessage()).contains("At least one primary.key.fields field name should be specified");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnWithPrimaryKeyModeRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id,name");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "id", "name");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnsWithPrimaryKeyModeRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id1,id2,name");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordMultipleKeyColumns(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id1", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "id2", ValueType.NUMBER, 10);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "id1", "id2", "name");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testRecordWithPrimaryKeyColumnsWithPrimaryKeyModeRecordValueWithSubsetOfFields(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id1,name");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordMultipleKeyColumns(topicName);
        this.consume(createRecord);
        String destinationTableName = this.destinationTableName(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), destinationTableName);
        tableAssert.exists().hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id1", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "id2", ValueType.NUMBER, 10);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.assertHasPrimaryKeyColumns(destinationTableName, "id1", "name");
    }

    protected void assertHasPrimaryKeyColumns(String tableName, String ... columnNames) {
        this.assertHasPrimaryKeyColumns(tableName, true, columnNames);
    }

    protected void assertHasPrimaryKeyColumns(String tableName, boolean caseInsensitive, String ... columnNames) {
        List<String> pkColumnNames = TestHelper.getPrimaryKeyColumnNames(this.dataSource(), tableName);
        if (columnNames.length == 0) {
            Assertions.assertThat(pkColumnNames).isEmpty();
        } else if (caseInsensitive) {
            pkColumnNames = pkColumnNames.stream().map(String::toLowerCase).collect(Collectors.toList());
            for (int columnIndex = 0; columnIndex < columnNames.length; ++columnIndex) {
                Assertions.assertThat(pkColumnNames).contains((Object)columnNames[columnIndex].toLowerCase(), Index.atIndex((int)columnIndex));
            }
        } else {
            Assertions.assertThat(pkColumnNames).containsExactly((Object[])columnNames);
        }
    }
}

