/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.Type;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SinkRecordDescriptor {
    private final SinkRecord record;
    private final String topicName;
    private final List<String> keyFieldNames;
    private final List<String> nonKeyFieldNames;
    private final Map<String, FieldDescriptor> fields;
    private final boolean flattened;

    private SinkRecordDescriptor(SinkRecord record, String topicName, List<String> keyFieldNames, List<String> nonKeyFieldNames, Map<String, FieldDescriptor> fields, boolean flattened) {
        this.record = record;
        this.topicName = topicName;
        this.keyFieldNames = keyFieldNames;
        this.nonKeyFieldNames = nonKeyFieldNames;
        this.fields = fields;
        this.flattened = flattened;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Integer getPartition() {
        return this.record.kafkaPartition();
    }

    public long getOffset() {
        return this.record.kafkaOffset();
    }

    public List<String> getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public List<String> getNonKeyFieldNames() {
        return this.nonKeyFieldNames;
    }

    public Map<String, FieldDescriptor> getFields() {
        return this.fields;
    }

    public boolean isDebeziumSinkRecord() {
        return !this.flattened;
    }

    public boolean isDelete() {
        if (!this.isDebeziumSinkRecord()) {
            return this.record.value() == null;
        }
        if (this.record.value() != null) {
            Struct value = (Struct)this.record.value();
            return Envelope.Operation.DELETE.equals((Object)Envelope.Operation.forCode((String)value.getString("op")));
        }
        return false;
    }

    public Struct getKeyStruct(JdbcSinkConnectorConfig.PrimaryKeyMode primaryKeyMode) {
        if (!this.getKeyFieldNames().isEmpty()) {
            switch (primaryKeyMode) {
                case RECORD_KEY: {
                    Schema keySchema = this.record.keySchema();
                    if (keySchema != null && Schema.Type.STRUCT.equals((Object)keySchema.type())) {
                        return (Struct)this.record.key();
                    }
                    throw new ConnectException("No struct-based primary key defined for record key.");
                }
                case RECORD_VALUE: {
                    Schema valueSchema = this.record.valueSchema();
                    if (valueSchema != null && Schema.Type.STRUCT.equals((Object)valueSchema.type())) {
                        return this.getAfterStruct();
                    }
                    throw new ConnectException("No struct-based primary key defined for record value.");
                }
                case RECORD_HEADER: {
                    SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct();
                    this.record.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
                    Schema headerSchema = headerSchemaBuilder.build();
                    Struct headerStruct = new Struct(headerSchema);
                    this.record.headers().forEach(header -> headerStruct.put(header.key(), header.value()));
                    return headerStruct;
                }
            }
        }
        return null;
    }

    public Struct getAfterStruct() {
        if (this.isDebeziumSinkRecord()) {
            return ((Struct)this.record.value()).getStruct("after");
        }
        return (Struct)this.record.value();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String CONNECT_TOPIC = "__connect_topic";
        private static final String CONNECT_PARTITION = "__connect_partition";
        private static final String CONNECT_OFFSET = "__connect_offset";
        private JdbcSinkConnectorConfig.PrimaryKeyMode primaryKeyMode;
        private Set<String> primaryKeyFields;
        private SinkRecord sinkRecord;
        private DatabaseDialect dialect;
        private List<String> keyFieldNames = new ArrayList<String>();
        private List<String> nonKeyFieldNames = new ArrayList<String>();
        private Map<String, FieldDescriptor> allFields = new LinkedHashMap<String, FieldDescriptor>();

        public Builder withDialect(DatabaseDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder withPrimaryKeyFields(Set<String> primaryKeyFields) {
            this.primaryKeyFields = primaryKeyFields;
            return this;
        }

        public Builder withPrimaryKeyMode(JdbcSinkConnectorConfig.PrimaryKeyMode primaryKeyMode) {
            this.primaryKeyMode = primaryKeyMode;
            return this;
        }

        public Builder withSinkRecord(SinkRecord record) {
            this.sinkRecord = record;
            return this;
        }

        public SinkRecordDescriptor build() {
            Objects.requireNonNull(this.primaryKeyMode, "The primary key mode must be provided.");
            Objects.requireNonNull(this.sinkRecord, "The sink record must be provided.");
            boolean flattened = this.isFlattened(this.sinkRecord);
            this.readSinkRecordKeyData(this.sinkRecord, flattened);
            this.readSinkRecordNonKeyData(this.sinkRecord, flattened);
            return new SinkRecordDescriptor(this.sinkRecord, this.sinkRecord.topic(), this.keyFieldNames, this.nonKeyFieldNames, this.allFields, flattened);
        }

        private boolean isFlattened(SinkRecord record) {
            Schema valueSchema = record.valueSchema();
            if (valueSchema != null) {
                for (Field field : valueSchema.fields()) {
                    if (!Schema.Type.STRUCT.equals((Object)field.schema().type())) continue;
                    return false;
                }
            }
            return true;
        }

        private void readSinkRecordKeyData(SinkRecord record, boolean flattened) {
            switch (this.primaryKeyMode) {
                case NONE: {
                    break;
                }
                case KAFKA: {
                    this.applyKafkaCoordinatesAsPrimaryKey();
                    break;
                }
                case RECORD_KEY: {
                    this.applyRecordKeyAsPrimaryKey(record);
                    break;
                }
                case RECORD_HEADER: {
                    this.applyRecordHeaderAsPrimaryKey(record);
                    break;
                }
                case RECORD_VALUE: {
                    this.applyRecordValueAsPrimaryKey(record, flattened);
                    break;
                }
                default: {
                    throw new ConnectException("Unexpected primary key mode: " + this.primaryKeyMode);
                }
            }
        }

        private void applyKafkaCoordinatesAsPrimaryKey() {
            this.keyFieldNames.add(CONNECT_TOPIC);
            this.allFields.put(CONNECT_TOPIC, new FieldDescriptor(Schema.STRING_SCHEMA, CONNECT_TOPIC, true, this.dialect));
            this.keyFieldNames.add(CONNECT_PARTITION);
            this.allFields.put(CONNECT_PARTITION, new FieldDescriptor(Schema.INT32_SCHEMA, CONNECT_PARTITION, true, this.dialect));
            this.keyFieldNames.add(CONNECT_OFFSET);
            this.allFields.put(CONNECT_OFFSET, new FieldDescriptor(Schema.INT64_SCHEMA, CONNECT_OFFSET, true, this.dialect));
        }

        private void applyRecordKeyAsPrimaryKey(SinkRecord record) {
            Schema keySchema = record.keySchema();
            if (keySchema == null) {
                throw new ConnectException("Configured primary key mode 'record_key' cannot have null schema");
            }
            if (keySchema.type().isPrimitive()) {
                this.applyPrimitiveRecordKeyAsPrimaryKey(keySchema);
            } else if (Schema.Type.STRUCT.equals((Object)keySchema.type())) {
                this.applyRecordKeyAsPrimaryKey(keySchema);
            } else {
                throw new ConnectException("An unsupported record key schema type detected: " + keySchema.type());
            }
        }

        private void applyRecordHeaderAsPrimaryKey(SinkRecord record) {
            if (record.headers() == null || record.headers().isEmpty()) {
                throw new ConnectException("Configured primary key mode 'record_header' cannot have null or empty schema");
            }
            SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct();
            record.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
            Schema headerSchema = headerSchemaBuilder.build();
            this.applyRecordKeyAsPrimaryKey(headerSchema);
        }

        private void applyRecordValueAsPrimaryKey(SinkRecord record, boolean flattened) {
            if (this.primaryKeyFields.isEmpty()) {
                throw new ConnectException("At least one primary.key.fields field name should be specified when resolving keys from the record's value.");
            }
            Schema valueSchema = record.valueSchema();
            if (valueSchema == null) {
                throw new ConnectException("Configured primary key mode 'record_value' cannot have null schema");
            }
            if (flattened) {
                for (Field field : record.valueSchema().fields()) {
                    if (!this.primaryKeyFields.contains(field.name())) continue;
                    this.addKeyField(field);
                }
            } else {
                Struct after = ((Struct)record.value()).getStruct("after");
                for (Field field : after.schema().fields()) {
                    if (!this.primaryKeyFields.contains(field.name())) continue;
                    this.addKeyField(field);
                }
            }
        }

        private void applyPrimitiveRecordKeyAsPrimaryKey(Schema keySchema) {
            if (this.primaryKeyFields.isEmpty()) {
                throw new ConnectException("The primary.key.fields configuration must be specified when using a primitive key.");
            }
            this.addKeyField(this.primaryKeyFields.iterator().next(), keySchema);
        }

        private void applyRecordKeyAsPrimaryKey(Schema keySchema) {
            for (Field field : keySchema.fields()) {
                if (!this.primaryKeyFields.isEmpty() && !this.primaryKeyFields.contains(field.name())) continue;
                this.addKeyField(field);
            }
        }

        private void addKeyField(Field field) {
            this.addKeyField(field.name(), field.schema());
        }

        private void addKeyField(String name, Schema schema) {
            this.keyFieldNames.add(name);
            this.allFields.put(name, new FieldDescriptor(schema, name, true, this.dialect));
        }

        private void readSinkRecordNonKeyData(SinkRecord record, boolean flattened) {
            Schema valueSchema = record.valueSchema();
            if (valueSchema != null) {
                if (flattened) {
                    this.applyNonKeyFields(valueSchema);
                } else {
                    Field after = valueSchema.field("after");
                    if (after == null) {
                        throw new ConnectException("Received an unexpected message type that does not have an 'after' Debezium block");
                    }
                    this.applyNonKeyFields(after.schema());
                }
            }
        }

        private void applyNonKeyFields(Schema schema) {
            for (Field field : schema.fields()) {
                if (this.keyFieldNames.contains(field.name())) continue;
                this.nonKeyFieldNames.add(field.name());
                this.allFields.put(field.name(), new FieldDescriptor(field.schema(), field.name(), false, this.dialect));
            }
        }
    }

    @Immutable
    public static class FieldDescriptor {
        private static final Logger LOGGER = LoggerFactory.getLogger(FieldDescriptor.class);
        private final Schema schema;
        private final String name;
        private final boolean key;
        private final Type type;
        private final DatabaseDialect dialect;
        private final String typeName;
        private String queryBinding;

        private FieldDescriptor(Schema schema, String name, boolean key, DatabaseDialect dialect) {
            this.schema = schema;
            this.name = name;
            this.key = key;
            this.dialect = dialect;
            this.type = dialect.getSchemaType(schema);
            this.typeName = this.type.getTypeName(dialect, schema, key);
            LOGGER.trace("Field [{}] with schema [{}]", (Object)name, (Object)schema.type());
            LOGGER.trace("    Type      : {}", (Object)this.type.getClass().getName());
            LOGGER.trace("    Optional  : {}", (Object)schema.isOptional());
            if (schema.parameters() != null && !schema.parameters().isEmpty()) {
                LOGGER.trace("    Parameters: {}", (Object)schema.parameters());
            }
            if (schema.defaultValue() != null) {
                LOGGER.trace("    Def. Value: {}", schema.defaultValue());
            }
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String getName() {
            return this.name;
        }

        public boolean isKey() {
            return this.key;
        }

        public Type getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getQueryBinding(ColumnDescriptor column) {
            if (this.queryBinding == null) {
                this.queryBinding = this.type.getQueryBinding(column, this.schema);
            }
            return this.queryBinding;
        }

        public void bind(NativeQuery<?> query, int startIndex, Object value) {
            this.type.bind((Query<?>)query, startIndex, this.schema, value);
        }

        public String toString() {
            return "FieldDescriptor{schema=" + this.schema + ", name='" + this.name + "', key=" + this.key + ", typeName='" + this.typeName + "', type=" + this.type + "}";
        }
    }
}

