/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.util;

import io.debezium.data.Envelope;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.sink.SinkRecord;

public class SinkRecordBuilder {
    private SinkRecordBuilder() {
    }

    public static SinkRecordTypeBuilder create() {
        return new SinkRecordTypeBuilder(Type.CREATE);
    }

    public static SinkRecordTypeBuilder update() {
        return new SinkRecordTypeBuilder(Type.UPDATE);
    }

    public static SinkRecordTypeBuilder delete() {
        return new SinkRecordTypeBuilder(Type.DELETE);
    }

    public static SinkRecordTypeBuilder tombstone() {
        return new SinkRecordTypeBuilder(Type.TOMBSTONE);
    }

    public static class SinkRecordTypeBuilder {
        private final Type type;
        private boolean flat;
        private String topicName;
        private String name;
        private Schema keySchema;
        private Schema recordSchema;
        private Schema sourceSchema;
        private int partition;
        private int offset;
        private Map<String, Object> keyValues = new HashMap<String, Object>();
        private Map<String, Object> beforeValues = new HashMap<String, Object>();
        private Map<String, Object> afterValues = new HashMap<String, Object>();
        private Map<String, Object> sourceValues = new HashMap<String, Object>();

        private SinkRecordTypeBuilder(Type type) {
            this.type = type;
        }

        public SinkRecordTypeBuilder flat(boolean flat) {
            this.flat = flat;
            return this;
        }

        public SinkRecordTypeBuilder topic(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public SinkRecordTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SinkRecordTypeBuilder keySchema(Schema keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        public SinkRecordTypeBuilder key(String fieldName, Object value) {
            this.keyValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder recordSchema(Schema recordSchema) {
            this.recordSchema = recordSchema;
            return this;
        }

        public SinkRecordTypeBuilder before(String fieldName, Object value) {
            this.beforeValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder after(String fieldName, Object value) {
            this.afterValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder sourceSchema(Schema sourceSchema) {
            this.sourceSchema = sourceSchema;
            return this;
        }

        public SinkRecordTypeBuilder source(String fieldName, Object value) {
            this.sourceValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder partition(int partition) {
            this.partition = partition;
            return this;
        }

        public SinkRecordTypeBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public SinkRecord build() {
            switch (this.type) {
                case CREATE: {
                    return this.buildCreateSinkRecord();
                }
                case UPDATE: {
                    return this.buildUpdateSinkRecord();
                }
                case DELETE: {
                    return this.buildDeleteSinkRecord();
                }
                case TOMBSTONE: {
                    return this.buildTombstoneSinkRecord();
                }
            }
            return null;
        }

        private SinkRecord buildCreateSinkRecord() {
            Objects.requireNonNull(this.recordSchema, "A record schema must be provided.");
            Objects.requireNonNull(this.sourceSchema, "A source schema must be provided.");
            Struct key = this.populateStructForKey();
            Struct after = this.populateStructFromMap(new Struct(this.recordSchema), this.afterValues);
            Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
            if (!this.flat) {
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.create((Object)after, source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, this.recordSchema, (Object)after, (long)this.offset);
        }

        private SinkRecord buildUpdateSinkRecord() {
            Objects.requireNonNull(this.recordSchema, "A record schema must be provided.");
            Objects.requireNonNull(this.sourceSchema, "A source schema must be provided.");
            Struct key = this.populateStructForKey();
            Struct before = this.populateStructFromMap(new Struct(this.recordSchema), this.beforeValues);
            Struct after = this.populateStructFromMap(new Struct(this.recordSchema), this.afterValues);
            Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
            if (!this.flat) {
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.update((Object)before, after, source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, this.recordSchema, (Object)after, (long)this.offset);
        }

        private SinkRecord buildDeleteSinkRecord() {
            Objects.requireNonNull(this.recordSchema, "A record schema must be provided.");
            Objects.requireNonNull(this.sourceSchema, "A source schema must be provided.");
            Struct key = this.populateStructForKey();
            Struct before = this.populateStructFromMap(new Struct(this.recordSchema), this.beforeValues);
            Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
            if (!this.flat) {
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.delete((Object)before, source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, this.recordSchema, null, (long)this.offset);
        }

        private SinkRecord buildTombstoneSinkRecord() {
            Struct key = this.populateStructForKey();
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, null, null, (long)this.offset);
        }

        private Envelope createEnvelope() {
            return Envelope.defineSchema().withRecord(this.recordSchema).withSource(this.sourceSchema).withName((Strings.isNullOrBlank((String)this.name) ? "dummy" : this.name) + ".Envelope").build();
        }

        private Struct populateStructFromMap(Struct struct, Map<String, Object> values) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                struct.put(entry.getKey(), entry.getValue());
            }
            return struct;
        }

        private Struct populateStructForKey() {
            if (this.keySchema != null) {
                return this.populateStructFromMap(new Struct(this.keySchema), this.keyValues);
            }
            return null;
        }
    }

    private static enum Type {
        CREATE,
        UPDATE,
        DELETE,
        TOMBSTONE;

    }
}

