/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.jupiter.PostgresSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-postgresql")})
@ExtendWith(value={PostgresSinkDatabaseContextProvider.class})
public class JdbcSinkColumnTypeMappingIT
extends AbstractJdbcSinkTest {
    public JdbcSinkColumnTypeMappingIT(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6589"})
    public void testShouldCoerceStringTypeToUuidColumnType(SinkRecordFactory factory) throws Exception {
        this.shouldCoerceStringTypeToColumnType(factory, "uuid", "9bc6a215-84b5-4865-a058-9156427c887a", "f54c2926-076a-4db0-846f-14cad99a8307");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6589"})
    public void testShouldCoerceStringTypeToJsonColumnType(SinkRecordFactory factory) throws Exception {
        this.shouldCoerceStringTypeToColumnType(factory, "json", "{\"id\": 12345}", "{\"id\": 67890}");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6589"})
    public void testShouldCoerceStringTypeToJsonbColumnType(SinkRecordFactory factory) throws Exception {
        this.shouldCoerceStringTypeToColumnType(factory, "jsonb", "{\"id\": 12345}", "{\"id\": 67890}");
    }

    private void shouldCoerceStringTypeToColumnType(SinkRecordFactory factory, String columnType, String insertValue, String updateValue) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        properties.put("delete.enabled", "false");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", Schema.OPTIONAL_STRING_SCHEMA, insertValue);
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data %s null, primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data %s null, primary key(id))", destinationTable, columnType));
        this.consume(createRecord);
        SinkRecord updateRecord = factory.updateRecordWithSchemaValue(topicName, (byte)1, "data", Schema.OPTIONAL_STRING_SCHEMA, updateValue);
        this.consume(updateRecord);
        this.getSink().assertColumn(destinationTable, "data", columnType);
    }
}

