/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.naming.DefaultTableNamingStrategy;
import io.debezium.connector.jdbc.util.DebeziumSinkRecordFactory;
import io.debezium.doc.FixFor;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="UnitTests")
public class TableNamingStrategyTest {
    @Test
    public void testDefaultTableNamingStrategy() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of());
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        Assertions.assertThat((String)strategy.resolveTableName(config, factory.createRecord("database.schema.table"))).isEqualTo((Object)"database_schema_table");
    }

    @Test
    public void testTableNamingStrategyWithTableNameFormat() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "kafka_${topic}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        Assertions.assertThat((String)strategy.resolveTableName(config, factory.createRecord("database.schema.table"))).isEqualTo((Object)"kafka_database_schema_table");
    }

    @Test
    @FixFor(value={"DBZ-6491"})
    public void testTableNamingStrategyWithPrependedSchema() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "SYS.${topic}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        Assertions.assertThat((String)strategy.resolveTableName(config, factory.createRecord("database.schema.table"))).isEqualTo((Object)"SYS.database_schema_table");
    }
}

