/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.SecondLevelCacheLogger;
import org.hibernate.cache.spi.TimestampsCache;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class QueryResultsCacheImpl
implements QueryResultsCache {
    private final QueryResultsRegion cacheRegion;
    private final TimestampsCache timestampsCache;

    QueryResultsCacheImpl(QueryResultsRegion cacheRegion, TimestampsCache timestampsCache) {
        this.cacheRegion = cacheRegion;
        this.timestampsCache = timestampsCache;
    }

    @Override
    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(QueryKey key, List<?> results, SharedSessionContractImplementor session) throws HibernateException {
        if (SecondLevelCacheLogger.DEBUG_ENABLED) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debugf("Caching query results in region: %s; timestamp=%s", this.cacheRegion.getName(), session.getTransactionStartTimestamp());
        }
        CacheItem cacheItem = new CacheItem(session.getTransactionStartTimestamp(), QueryResultsCacheImpl.deepCopy(results));
        try {
            session.getEventListenerManager().cachePutStart();
            this.cacheRegion.putIntoCache(key, cacheItem, session);
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
        return true;
    }

    private static <T> List<T> deepCopy(List<T> results) {
        return new ArrayList<T>(results);
    }

    @Override
    public List<?> get(QueryKey key, Set<String> spaces, SharedSessionContractImplementor session) throws HibernateException {
        CacheItem cacheItem;
        if (SecondLevelCacheLogger.DEBUG_ENABLED) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debugf("Checking cached query results in region: %s", this.cacheRegion.getName());
        }
        if ((cacheItem = this.getCachedData(key, session)) == null) {
            if (SecondLevelCacheLogger.DEBUG_ENABLED) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Query results were not found in cache");
            }
            return null;
        }
        if (!this.timestampsCache.isUpToDate(spaces, cacheItem.timestamp, session)) {
            if (SecondLevelCacheLogger.DEBUG_ENABLED) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (SecondLevelCacheLogger.DEBUG_ENABLED) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Returning cached query results");
        }
        return QueryResultsCacheImpl.deepCopy(cacheItem.results);
    }

    @Override
    public List<?> get(QueryKey key, String[] spaces, SharedSessionContractImplementor session) throws HibernateException {
        CacheItem cacheItem;
        if (SecondLevelCacheLogger.DEBUG_ENABLED) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debugf("Checking cached query results in region: %s", this.cacheRegion.getName());
        }
        if ((cacheItem = this.getCachedData(key, session)) == null) {
            if (SecondLevelCacheLogger.DEBUG_ENABLED) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Query results were not found in cache");
            }
            return null;
        }
        if (!this.timestampsCache.isUpToDate(spaces, cacheItem.timestamp, session)) {
            if (SecondLevelCacheLogger.DEBUG_ENABLED) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (SecondLevelCacheLogger.DEBUG_ENABLED) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Returning cached query results");
        }
        return QueryResultsCacheImpl.deepCopy(cacheItem.results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheItem getCachedData(QueryKey key, SharedSessionContractImplementor session) {
        CacheItem cachedItem = null;
        try {
            session.getEventListenerManager().cacheGetStart();
            cachedItem = (CacheItem)this.cacheRegion.getFromCache(key, session);
            session.getEventListenerManager().cacheGetEnd(cachedItem != null);
        }
        catch (Throwable throwable) {
            session.getEventListenerManager().cacheGetEnd(cachedItem != null);
            throw throwable;
        }
        return cachedItem;
    }

    public String toString() {
        return "QueryResultsCache(" + this.cacheRegion.getName() + ")";
    }

    public static class CacheItem
    implements Serializable {
        private final Long timestamp;
        private final List<?> results;

        CacheItem(long timestamp, List<?> results) {
            this.timestamp = timestamp;
            this.results = results;
        }
    }
}

