/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTemporalType;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public abstract class AbstractTimestampType
extends AbstractTemporalType {
    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0 && precision <= dialect.getMaxTimestampPrecision()) {
            return dialect.getTypeName(this.getJdbcType(), Size.precision((int)precision));
        }
        return dialect.getTypeName(this.getJdbcType());
    }

    protected int getTimePrecision(Schema schema) {
        String length = this.getSourceColumnSize(schema).orElse("0");
        Optional<String> scale = this.getSourceColumnPrecision(schema);
        return scale.map(Integer::parseInt).orElseGet(() -> Integer.parseInt(length));
    }

    protected int getJdbcType() {
        return 93;
    }
}

