/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.assertj.db.api.Assertions;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.Source;
import org.assertj.db.type.Table;

public class TestHelper {
    private TestHelper() {
    }

    public static boolean shouldQueryDatabaseState() {
        return Boolean.parseBoolean(System.getProperty("query.database.state", "false"));
    }

    public static boolean isSourceSnapshot() {
        return Boolean.parseBoolean(System.getProperty("source.snapshot", "false"));
    }

    public static boolean isDefaultValuesEnabled() {
        return Boolean.parseBoolean(System.getProperty("source.use.default.values", "false"));
    }

    public static boolean isConnectionTimeZoneUsed() {
        return Boolean.parseBoolean(System.getProperty("connection.time_zone", "true"));
    }

    public static String getSourceTimeZone() {
        return System.getProperty("source.time_zone", "UTC");
    }

    public static String getSinkTimeZone() {
        return System.getProperty("sink.time_zone", "UTC");
    }

    public static TableAssert assertTable(DataSource dataSource, String tableName) {
        return Assertions.assertThat((Table)new Table(dataSource, tableName));
    }

    public static TableAssert assertTable(Source source, String tableName) {
        return Assertions.assertThat((Table)new Table(source, tableName));
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = t.getCause();
        }
        return result;
    }

    public static List<String> getPrimaryKeyColumnNames(DataSource dataSource, String tableName) {
        ArrayList<String> arrayList;
        block16: {
            Connection connection = dataSource.getConnection();
            try {
                TreeMap<Integer, String> primaryKeyColumnNames = new TreeMap<Integer, String>();
                try (ResultSet rs = connection.getMetaData().getPrimaryKeys(null, null, tableName);){
                    while (rs.next()) {
                        primaryKeyColumnNames.put(rs.getInt(5), rs.getString(4));
                    }
                }
                arrayList = new ArrayList<String>(primaryKeyColumnNames.values());
                if (connection == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Failed to read table '" + tableName + "' primary key columns", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }
}

