/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.ValueType;
import org.fest.assertions.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public abstract class AbstractJdbcSinkInsertModeTest
extends AbstractJdbcSinkTest {
    public AbstractJdbcSinkInsertModeTest(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeInsertWithNoPrimaryKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.NONE.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        this.consume(factory.createRecordNoKey(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(2)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe", "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeInsertWithPrimaryKeyModeKafka(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.KAFKA.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(2)).hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "__connect_topic", ValueType.TEXT, topicName, topicName);
        this.getSink().assertColumnType(tableAssert, "__connect_partition", ValueType.NUMBER, 0, 0);
        this.getSink().assertColumnType(tableAssert, "__connect_offset", ValueType.NUMBER, 0, 1);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe", "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeInsertWithPrimaryKeyModeRecordKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName, (byte)1);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName, (byte)2));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(2)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1, (byte)2);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe", "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeInsertWithPrimaryKeyModeRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName, (byte)1);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName, (byte)2));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(2)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1, (byte)2);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe", "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpsertWithNoPrimaryKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.NONE.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        try {
            this.consume(factory.createRecordNoKey(topicName));
        }
        catch (Exception e) {
            Assertions.assertThat((String)TestHelper.getRootCause(e).getMessage()).matches("Cannot write to table [a-zA-Z0-9_]* with no key fields defined\\.");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpsertWithPrimaryKeyModeKafka(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.KAFKA.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName, (byte)1);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName, (byte)1));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "__connect_topic", ValueType.TEXT, topicName);
        this.getSink().assertColumnType(tableAssert, "__connect_partition", ValueType.NUMBER, 0);
        this.getSink().assertColumnType(tableAssert, "__connect_offset", ValueType.NUMBER, 1L);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpsertWithPrimaryKeyModeRecordKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName, (byte)1);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName, (byte)1));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpsertWithPrimaryKeyModeRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName, (byte)1);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName, (byte)1));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpdateWithNoPrimaryKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.NONE.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPDATE.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpdateWithPrimaryKeyModeKafka(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.KAFKA.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPDATE.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(5);
        this.getSink().assertColumnType(tableAssert, "__connect_topic", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "__connect_partition", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "__connect_offset", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpdateWithPrimaryKeyModeRecordKey(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPDATE.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testInsertModeUpdateWithPrimaryKeyModeRecordValue(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPDATE.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }
}

