/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.DotIdentifierSequence;

public class PropertyPath
implements DotIdentifierSequence {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final PropertyPath parent;
    private final String property;
    private final String fullPath;

    public PropertyPath(PropertyPath parent, String property) {
        this.parent = parent;
        this.property = property;
        if (IDENTIFIER_MAPPER_PROPERTY.equals(property)) {
            this.fullPath = parent != null ? parent.getFullPath() : "";
        } else {
            String resolvedParent;
            Object prefix = parent != null ? (StringHelper.isEmpty(resolvedParent = parent.getFullPath()) ? "" : resolvedParent + ".") : "";
            this.fullPath = (String)prefix + property;
        }
    }

    public PropertyPath(String property) {
        this(null, property);
    }

    public PropertyPath() {
        this("");
    }

    @Override
    public PropertyPath append(String property) {
        return new PropertyPath(this, property);
    }

    @Override
    public PropertyPath getParent() {
        return this.parent;
    }

    @Override
    public String getLocalName() {
        return this.property;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null && StringHelper.isEmpty(this.property);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fullPath + "]";
    }
}

