/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.relational;

import io.debezium.annotation.Immutable;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.relational.TableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Immutable
public class TableDescriptor {
    private final TableId id;
    private final String tableType;
    private final Map<String, ColumnDescriptor> columns = new LinkedHashMap<String, ColumnDescriptor>();
    private final List<String> primaryKeyColumnNames;

    private TableDescriptor(TableId id, String tableType, List<ColumnDescriptor> columns, List<String> primaryKeyColumnNames) {
        this.id = id;
        this.tableType = tableType;
        this.primaryKeyColumnNames = primaryKeyColumnNames;
        columns.forEach(c -> this.columns.put(c.getColumnName(), (ColumnDescriptor)c));
    }

    public TableId getId() {
        return this.id;
    }

    public String getTableType() {
        return this.tableType;
    }

    public Collection<ColumnDescriptor> getColumns() {
        return this.columns.values();
    }

    public ColumnDescriptor getColumnByName(String columnName) {
        return this.columns.get(columnName);
    }

    public boolean hasColumn(String columnName) {
        return this.columns.containsKey(columnName);
    }

    public List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    public Collection<ColumnDescriptor> getPrimaryKeyColumns() {
        return this.columns.values().stream().filter(c -> this.primaryKeyColumnNames.contains(c.getColumnName())).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String catalogName;
        private String schemaName;
        private String tableName;
        private String tableType;
        private List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        private List<String> primaryKeyColumnNames = new ArrayList<String>();

        private Builder() {
        }

        public Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder type(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public Builder column(ColumnDescriptor column) {
            this.columns.add(column);
            return this;
        }

        public Builder columns(List<ColumnDescriptor> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder keyColumn(ColumnDescriptor column) {
            return this.keyColumn(column.getColumnName());
        }

        public Builder keyColumn(String columnName) {
            this.primaryKeyColumnNames.add(columnName);
            return this;
        }

        public TableDescriptor build() {
            TableId id = new TableId(this.catalogName, this.schemaName, this.tableName);
            return new TableDescriptor(id, this.tableType, this.columns, this.primaryKeyColumnNames);
        }
    }
}

