/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

class BytesType
extends AbstractType {
    public static final BytesType INSTANCE = new BytesType();

    BytesType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"BYTES"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        Optional<String> columnType = this.getSourceColumnType(schema);
        if (columnType.isPresent()) {
            if ("TINYBLOB".equalsIgnoreCase(columnType.get())) {
                return "tinyblob";
            }
            if ("MEDIUMBLOB".equalsIgnoreCase(columnType.get())) {
                return "mediumblob";
            }
            if ("BLOB".equalsIgnoreCase(columnType.get())) {
                return "blob";
            }
            if ("LARGEBLOB".equalsIgnoreCase(columnType.get())) {
                return "largeblob";
            }
            int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
            if (columnSize > 0) {
                return dialect.getTypeName(-3, Size.length((long)columnSize));
            }
        }
        return dialect.getTypeName(-3);
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return null;
    }
}

