/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.time.ZonedTime;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class ZonedTimeType
extends AbstractTimeType {
    public static final ZonedTimeType INSTANCE = new ZonedTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTime"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0) {
            return dialect.getTypeName(this.getJdbcType(dialect), Size.precision((int)precision));
        }
        return dialect.getTypeName(this.getJdbcType(dialect), Size.precision((int)dialect.getMaxTimePrecision()));
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTimeWithTimeZone((String)value);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof String) {
            ZonedDateTime zdt = OffsetTime.parse((String)value, ZonedTime.FORMATTER).atDate(LocalDate.now()).toZonedDateTime();
            if (this.getDialect().isTimeZoneSet()) {
                if (this.getDialect().shouldBindTimeWithTimeZoneAsDatabaseTimeZone()) {
                    query.setParameter(index, (Object)zdt.withZoneSameInstant(this.getDatabaseTimeZone().toZoneId()));
                } else {
                    query.setParameter(index, (Object)zdt, (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITH_TIMEZONE);
                }
            } else {
                this.bindWithNoTimeZoneDetails(query, index, zdt);
            }
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    protected void bindWithNoTimeZoneDetails(Query<?> query, int index, ZonedDateTime zonedDateTime) {
        query.setParameter(index, (Object)zonedDateTime);
    }

    protected int getJdbcType(DatabaseDialect dialect) {
        return 2013;
    }
}

